/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.FunctionLibrary;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.process.StripList;
import com.novell.xsl.process.URIcontext;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Context
extends ExpressionContext
implements URIcontext {
    protected Map uriMap = new HashMap();
    protected StripList stripList;
    protected Stylesheet stylesheet;
    protected FunctionLibrary library;

    public Context(Stylesheet stylesheet, FunctionLibrary library, Map properties) {
        super(properties);
        this.stylesheet = stylesheet;
        this.library = library;
    }

    public Context(ExpressionContext iVal) {
        super(iVal);
        if (iVal instanceof Context) {
            this.uriMap.putAll(((Context)iVal).uriMap);
            this.stripList = ((Context)iVal).stripList;
            this.stylesheet = ((Context)iVal).stylesheet;
            this.library = ((Context)iVal).library;
        } else {
            this.stylesheet = null;
            this.library = null;
            this.stripList = null;
        }
    }

    public Stylesheet getStylesheet() {
        return this.stylesheet;
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.library;
    }

    public Node getCurrentStylesheetNode() {
        return this.getNamespaceContext();
    }

    public void clearBaseURIs() {
        this.uriMap.clear();
    }

    public void setStripList(StripList stripList) {
        this.stripList = stripList;
    }

    public URL getBaseURI(Node node) {
        Document document = node.getOwnerDocument();
        if (document == null) {
            document = (Document)node;
        }
        return (URL)this.uriMap.get(document);
    }

    public void addBaseURI(Node node, URL baseURI) {
        Document document = node.getOwnerDocument();
        if (document == null) {
            document = (Document)node;
        }
        this.uriMap.put(document, baseURI);
    }

    public boolean stripNode(Node node) {
        if (this.stripList == null || this.stripList.size() == 0) {
            return false;
        }
        String nodeValue = node.getNodeValue();
        if (nodeValue == null) {
            return false;
        }
        if (XMLUtil.isXMLWhitespace(nodeValue)) {
            Node sibling;
            Node parent = node.getParentNode();
            if (!this.stripList.checkStrip(parent)) {
                return false;
            }
            while (parent != null) {
                Attr attr;
                if (parent.getNodeType() == 1 && (attr = ((Element)parent).getAttributeNode("xml:space")) != null) {
                    String value = attr.getNodeValue();
                    if (value.equals("preserve")) {
                        return false;
                    }
                    if (value.equals("default")) {
                        return true;
                    }
                }
                parent = parent.getParentNode();
            }
            for (sibling = node.getPreviousSibling(); sibling != null && XPathUtil.getNodeType(sibling) == 3; sibling = sibling.getPreviousSibling()) {
                if (XMLUtil.isXMLWhitespace(sibling.getNodeValue())) continue;
                return false;
            }
            for (sibling = node.getNextSibling(); sibling != null && XPathUtil.getNodeType(sibling) == 3; sibling = sibling.getNextSibling()) {
                if (XMLUtil.isXMLWhitespace(sibling.getNodeValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

