/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.Namespace;
import com.novell.xml.xpath.AxisAttribute;
import com.novell.xml.xpath.AxisNamespace;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.ResultTreeFragment;
import com.novell.xsl.process.Template;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Comment;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class CopyOfTemplate
implements Template {
    private final Expression select;
    private final Node nsContext;

    public CopyOfTemplate(Expression select, Node nsContext) {
        this.select = select;
        this.nsContext = nsContext;
    }

    public Expression getSelect() {
        return this.select;
    }

    public void instantiate(ProcessingEnv env, Node currentNode, ResultHandler result) throws XSLException {
        Trace.traceTemplate("copy-of");
        try {
            ExpressionValue value = env.getContext().evaluate(currentNode, this.select);
            Trace.traceSelect(this.select, value);
            if (value.getValueType() == 3) {
                this.copyNodeSet(value.getNodeSetValue(), result, env);
            } else if (value.getValueType() == 4 && value instanceof ResultTreeFragment) {
                this.copyResultFragment((ResultTreeFragment)value, result, env);
            } else {
                result.characters(value.getStringValue());
            }
        }
        catch (IllegalNodeException e) {
            env.reportError(this.getNamespaceContext(), "pe7");
        }
        catch (ResultException e) {
            env.reportError(this.getNamespaceContext(), "pe8", e.getMessage());
        }
        catch (XPathEvaluationException e) {
            env.reportError(this.getNamespaceContext(), "pe2", e.getMessage());
        }
    }

    public Node getNamespaceContext() {
        return this.nsContext;
    }

    public void dump(PrintWriter out, int indent) {
        Util.indent(out, indent);
        out.println("copy-of");
        Util.indent(out, indent + 1);
        out.println("select:");
        this.select.dump(out, indent + 2);
    }

    private void copyNode(Node node, ResultHandler result, ProcessingEnv env, boolean strip) throws IllegalNodeException, ResultException, XSLException {
        switch (XPathUtil.getNodeType(node)) {
            case 2: {
                result.attribute(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 1: {
                result.startElement(node.getNodeName(), DOMUtil.getNamespaceName(node).getString());
                AxisAttribute attrs = new AxisAttribute();
                attrs.setup(node, env.getContext());
                Node attr = attrs.first();
                while (attr != null) {
                    this.copyNode(attr, result, env, strip);
                    attr = attrs.next();
                }
                AxisNamespace namespaceAxis = new AxisNamespace();
                namespaceAxis.setup(node, env.getContext());
                Node namespaceNode = namespaceAxis.first();
                while (namespaceNode != null) {
                    ProcessingEnv.resultNamespace(result, namespaceNode.getNodeName(), ((Namespace)namespaceNode).getNamespaceName());
                    namespaceNode = namespaceAxis.next();
                }
                Node childNode = node.getFirstChild();
                while (childNode != null) {
                    this.copyNode(childNode, result, env, strip);
                    childNode = XPathUtil.getNextSibling(childNode);
                }
                result.endElement(node.getNodeName());
                break;
            }
            case 7: {
                result.processingInstruction(((ProcessingInstruction)node).getTarget(), ((ProcessingInstruction)node).getData());
                break;
            }
            case 8: {
                result.comment(((Comment)node).getNodeValue());
                break;
            }
            case 3: {
                if (strip && env.getContext().stripNode(node)) break;
                result.characters(XPathUtil.getNodeValue(node));
                break;
            }
            case 9: 
            case 11: {
                Node childNode = node.getFirstChild();
                while (childNode != null) {
                    this.copyNode(childNode, result, env, strip);
                    childNode = XPathUtil.getNextSibling(childNode);
                }
                break;
            }
            case -1: {
                ProcessingEnv.resultNamespace(result, node.getNodeName(), ((Namespace)node).getNamespaceName());
                break;
            }
        }
    }

    private void copyNodeSet(NodeSet set, ResultHandler result, ProcessingEnv env) throws IllegalNodeException, ResultException, XSLException {
        Node node = set.first();
        while (node != null) {
            this.copyNode(node, result, env, true);
            node = set.next();
        }
    }

    private void copyResultFragment(ResultTreeFragment fragment, ResultHandler result, ProcessingEnv env) throws IllegalNodeException, ResultException, XSLException {
        Node root = fragment.getRoot();
        if (root != null) {
            this.copyNode(root, result, env, false);
        }
    }
}

