/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.Namespace;
import com.novell.xml.xpath.AxisNamespace;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.AttributeSetCollection;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateCollection;
import com.novell.xsl.result.AttributeAfterChildException;
import com.novell.xsl.result.IllegalNameException;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import java.util.Collection;
import org.w3c.dom.Node;

public class CopyTemplate
extends TemplateCollection {
    private final AttributeSetCollection attributeSets;

    public CopyTemplate(Collection attributeSetNames, Template[] templates, Node nsContext) {
        super(templates, nsContext);
        this.attributeSets = attributeSetNames != null && attributeSetNames.size() != 0 ? new AttributeSetCollection(attributeSetNames) : null;
    }

    public void instantiate(ProcessingEnv env, Node currentNode, ResultHandler result) throws XSLException {
        Trace.traceTemplate("copy");
        try {
            switch (XPathUtil.getNodeType(currentNode)) {
                case 9: 
                case 11: {
                    this.instantiateTemplates(env, currentNode, result);
                    break;
                }
                case 1: {
                    String elemName = currentNode.getNodeName();
                    String elemNamespaceURI = DOMUtil.getNamespaceName(currentNode).getString();
                    result.startElement(elemName, elemNamespaceURI);
                    AxisNamespace namespaceAxis = new AxisNamespace();
                    namespaceAxis.setup(currentNode, env.getContext());
                    Node namespaceNode = namespaceAxis.first();
                    while (namespaceNode != null) {
                        ProcessingEnv.resultNamespace(result, namespaceNode.getNodeName(), ((Namespace)namespaceNode).getNamespaceName());
                        namespaceNode = namespaceAxis.next();
                    }
                    if (this.attributeSets != null) {
                        this.attributeSets.instantiate(env, currentNode, result);
                    }
                    this.instantiateTemplates(env, currentNode, result);
                    result.endElement(elemName);
                    break;
                }
                case 2: {
                    result.attribute(currentNode.getNodeName(), currentNode.getNodeValue());
                    break;
                }
                case 8: {
                    result.comment(currentNode.getNodeValue());
                    break;
                }
                case 7: {
                    result.processingInstruction(currentNode.getNodeName(), currentNode.getNodeValue());
                    break;
                }
                case 3: {
                    result.characters(XPathUtil.getNodeValue(currentNode));
                    break;
                }
                case -1: {
                    ProcessingEnv.resultNamespace(result, currentNode.getNodeName(), ((Namespace)currentNode).getNamespaceName());
                    break;
                }
            }
        }
        catch (AttributeAfterChildException e) {
            env.reportError(this.getNamespaceContext(), "pe6", currentNode.getNodeName());
        }
        catch (IllegalNameException e) {
            env.reportError(this.getNamespaceContext(), "pe5", currentNode.getNodeName());
        }
        catch (IllegalNodeException e) {
            env.reportError(this.getNamespaceContext(), "pe7");
        }
        catch (ResultException e) {
            env.reportError(this.getNamespaceContext(), "pe8", e.getMessage());
        }
    }

    public void dump(PrintWriter out, int indent) {
        Util.indent(out, indent);
        out.println("copy");
        super.dump(out, indent);
    }
}

