/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.xpath.WildcardName;
import com.novell.xsl.process.Priority;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Element;

public class ElementMatch
implements Comparable {
    private final WildcardName name;
    private final boolean strip;
    private final int importance;
    private final Priority priority;
    private final int number;

    public ElementMatch(WildcardName name, boolean strip, int importance, int number) {
        this.name = name;
        this.strip = strip;
        this.importance = importance;
        this.number = number;
        this.priority = Priority.create(Util.getWildcardNamePriority(name));
    }

    public boolean matches(Element element) {
        return this.name.evaluate(element);
    }

    public boolean isStrip() {
        return this.strip;
    }

    public int compareTo(Object obj) {
        ElementMatch rhs = (ElementMatch)obj;
        if (this.importance != rhs.importance) {
            return rhs.importance - this.importance;
        }
        int i = rhs.priority.compareTo(this.priority);
        if (i != 0) {
            return i;
        }
        return rhs.number - this.number;
    }

    public int getNumber() {
        return this.number;
    }

    public void dump(PrintWriter out, int indent) {
        out.println(this.name.toString() + " importance=" + this.importance + " number=" + this.number + " strip=" + this.strip);
    }
}

