/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.AttributeSetCollection;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateCollection;
import com.novell.xsl.result.IllegalNameException;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import java.util.Collection;
import org.w3c.dom.Node;

public class ElementTemplate
extends TemplateCollection {
    private final Expression name;
    private final Expression namespace;
    private final AttributeSetCollection attributeSets;

    public ElementTemplate(Expression name, Expression namespace, Collection attributeSetNames, Template[] templates, Node nsContext) {
        super(templates, nsContext);
        this.name = name;
        this.namespace = namespace;
        this.attributeSets = attributeSetNames != null && attributeSetNames.size() != 0 ? new AttributeSetCollection(attributeSetNames) : null;
    }

    public void instantiate(ProcessingEnv env, Node currentNode, ResultHandler result) throws XSLException {
        Trace.traceTemplate("element");
        String elemName = "";
        try {
            int index;
            elemName = env.getContext().evaluate(currentNode, this.name).getStringValue();
            if (!XMLUtil.isQName(elemName)) {
                env.reportError(this.getNamespaceContext(), "pe5", elemName);
            }
            String prefix = (index = elemName.indexOf(58)) != -1 ? elemName.substring(0, index) : "";
            NamespaceName namespaceName = this.namespace == null ? env.getContext().getNamespaceName(prefix) : new NamespaceName(env.getContext().evaluate(currentNode, this.namespace).getStringValue());
            result.startElement(elemName, namespaceName.getString());
            if (namespaceName != null && !namespaceName.isEmpty()) {
                ProcessingEnv.resultNamespace(result, prefix, namespaceName);
            }
            if (this.attributeSets != null) {
                this.attributeSets.instantiate(env, currentNode, result);
            }
            this.instantiateTemplates(env, currentNode, result);
            result.endElement(elemName);
        }
        catch (XPathEvaluationException e) {
            env.reportError(this.getNamespaceContext(), "pe2", e.getMessage());
        }
        catch (IllegalNameException e) {
            env.reportError(this.getNamespaceContext(), "pe5", elemName);
        }
        catch (IllegalNodeException e) {
            env.reportError(this.getNamespaceContext(), "pe7");
        }
        catch (ResultException e) {
            env.reportError(this.getNamespaceContext(), "pe8", e.getMessage());
        }
    }

    public void dump(PrintWriter out, int indent) {
        Util.indent(out, indent);
        out.println("element");
        Util.indent(out, indent + 1);
        out.println("name");
        this.name.dump(out, indent + 2);
        super.dump(out, indent);
    }
}

