/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.xpath.ContextNodeList;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.SortCriteria;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateCollection;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class ForEachTemplate
extends TemplateCollection {
    private final Expression select;
    private final SortCriteria sortCriteria;

    public ForEachTemplate(Expression select, Template[] templates, SortCriteria sortCriteria, Node nsContext) {
        super(templates, nsContext);
        this.select = select;
        this.sortCriteria = sortCriteria;
    }

    public Expression getSelect() {
        return this.select;
    }

    public SortCriteria getSortCriteria() {
        return this.sortCriteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instantiate(ProcessingEnv env, Node currentNode, ResultHandler result) throws XSLException {
        Trace.traceTemplate("for-each");
        env.pushCurrentRule(null);
        try {
            env.getContext().pushState();
            try {
                try {
                    ContextNodeList list = env.getContext().evaluate(currentNode, this.select).getNodeSetValue();
                    Trace.traceSelect(this.select, (ExpressionValue)((Object)list));
                    if (this.sortCriteria != null) {
                        list = this.sortCriteria.sort(env, currentNode, list);
                    }
                    env.getContext().setContextNodeList(list);
                    Node node = list.first();
                    while (node != null) {
                        this.instantiateTemplates(env, node, result);
                        node = list.next();
                    }
                }
                catch (XPathEvaluationException e) {
                    env.reportError(this.getNamespaceContext(), "pe2", e.getMessage());
                }
            }
            finally {
                env.getContext().popState();
            }
        }
        finally {
            env.popCurrentRule();
        }
    }

    public void dump(PrintWriter out, int indent) {
        Util.indent(out, indent);
        out.println("for-each");
        Util.indent(out, indent + 1);
        out.println("select");
        this.select.dump(out, indent + 2);
        if (this.sortCriteria != null) {
            this.sortCriteria.dump(out, indent + 2);
        }
        super.dump(out, indent + 1);
    }
}

