/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateCollection;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class IfTemplate
extends TemplateCollection {
    private final Expression test;

    public IfTemplate(Expression test, Template[] templates, Node nsContext) {
        super(templates, nsContext);
        this.test = test;
    }

    public Expression getTest() {
        return this.test;
    }

    public void instantiate(ProcessingEnv env, Node currentNode, ResultHandler result) throws XSLException {
        Trace.traceTemplate("if");
        try {
            if (env.getContext().evaluate(currentNode, this.test).getBooleanValue()) {
                this.instantiateTemplates(env, currentNode, result);
            }
        }
        catch (XPathEvaluationException e) {
            env.reportError(this.getNamespaceContext(), "pe2", e.getMessage());
        }
    }

    public void dump(PrintWriter out, int indent) {
        Util.indent(out, indent);
        out.println("if");
        this.test.dump(out, indent + 1);
        super.dump(out, indent + 1);
    }
}

