/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.Axis;
import com.novell.xml.xpath.AxisDescendantOrSelf;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.SingleNodeList;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathResetCache;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;

public class Key
implements XPathResetCache {
    private ExpandedQName name;
    private Pattern match;
    private Expression use;
    private Node namespaceContext;
    private Axis axis = null;
    private SingleNodeList nodeList = null;
    private Map cacheMap = null;

    public Key(ExpandedQName name, Pattern match, Expression use, Node namespaceContext) {
        this.name = name;
        this.match = match;
        this.use = use;
        this.namespaceContext = namespaceContext;
    }

    public ExpandedQName getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeSet evaluate(String value, Node contextNode, ExpressionContext context) throws XPathEvaluationException {
        NodeSet result;
        Node root = contextNode.getOwnerDocument();
        Node node = root = root == null ? contextNode : root;
        if (this.axis == null) {
            this.axis = new AxisDescendantOrSelf();
        }
        if ((result = this.getCachedResult(root, value)) != null) {
            return result;
        }
        if (this.nodeList == null) {
            this.nodeList = new SingleNodeList();
        }
        context.pushState();
        try {
            context.setNamespaceContext(this.namespaceContext);
            this.axis.setup(root, context);
            result = new NodeSet();
            Node node2 = this.axis.first();
            while (node2 != null) {
                if (this.match.match(node2, context)) {
                    this.nodeList.setNode(node2);
                    context.setContextNodeList(this.nodeList);
                    ExpressionValue useValue = this.use.evaluate(node2, context);
                    if (useValue.getValueType() == 3) {
                        NodeSet values = useValue.getNodeSetValue();
                        Node valueNode = values.first();
                        while (valueNode != null) {
                            if (value.equals(XPathUtil.getNodeValue(valueNode))) {
                                result.add(node2);
                                break;
                            }
                            valueNode = values.next();
                        }
                    } else if (value.equals(useValue.getStringValue())) {
                        result.add(node2);
                    }
                }
                node2 = this.axis.next();
            }
            this.cacheResult(root, value, result);
            NodeSet nodeSet = result;
            return nodeSet;
        }
        finally {
            context.popState();
        }
    }

    public void resetCache() {
        this.cacheMap = null;
    }

    public void dump(PrintWriter writer, int indent) {
        Util.indent(writer, indent);
        writer.print("Key: '");
        writer.print(this.name.getQName());
        writer.println('\'');
        this.match.dump(writer, indent + 1);
        this.use.dump(writer, indent + 1);
    }

    private void cacheResult(Node document, String value, NodeSet result) {
        if (this.cacheMap == null) {
            this.cacheMap = new HashMap();
        }
        this.cacheMap.put(new CacheKey(document, value), result);
    }

    private NodeSet getCachedResult(Node document, String value) {
        if (this.cacheMap != null) {
            return (NodeSet)this.cacheMap.get(new CacheKey(document, value));
        }
        return null;
    }

    private static class CacheKey {
        private final int hash;
        private final Node document;
        private final String value;

        public CacheKey(Node document, String value) {
            int temp = value.hashCode();
            int top = temp >> 24 & 0xFF;
            this.hash = document.hashCode() * 37 + value.hashCode() | top;
            this.document = document;
            this.value = value;
        }

        public boolean equals(Object rhs) {
            return rhs instanceof CacheKey && this.document.equals(((CacheKey)rhs).document) && this.value.equals(((CacheKey)rhs).value);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

