/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.Namespace;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.xpath.AxisNamespace;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.AttributeSetCollection;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateCollection;
import com.novell.xsl.result.AttributeAfterChildException;
import com.novell.xsl.result.IllegalNameException;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class LiteralElementTemplate
extends TemplateCollection {
    private String elementName;
    private String[] attributeNames;
    private Expression[] attributeValues;
    private Set extNamespaces;
    private Set excludedNamespaces;
    private AttributeSetCollection attributeSets;

    public LiteralElementTemplate(String elementName, String[] attributeNames, Expression[] attributeValues, Set extNamespaces, Set excludedNamespaces, Collection attributeSetNames, Template[] templates, Node nsNode) {
        super(templates, nsNode);
        this.elementName = elementName;
        if (attributeNames.length != attributeValues.length) {
            throw new IllegalArgumentException("mismatched number of attribute names and values");
        }
        if (attributeNames.length > 0) {
            this.attributeNames = attributeNames;
            this.attributeValues = attributeValues;
        } else {
            this.attributeNames = null;
            this.attributeValues = null;
        }
        this.extNamespaces = extNamespaces;
        this.excludedNamespaces = excludedNamespaces;
        this.attributeSets = attributeSetNames != null && attributeSetNames.size() != 0 ? new AttributeSetCollection(attributeSetNames) : null;
    }

    public void instantiate(ProcessingEnv env, Node currentNode, ResultHandler result) throws XSLException {
        Trace.traceTemplate("<" + this.elementName + ">");
        try {
            NamespaceName nsName;
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            HashMap<NamespaceName, String> namespaceMap = new HashMap<NamespaceName, String>();
            Stylesheet stylesheet = env.getStylesheet();
            if (this.attributeNames != null) {
                for (int i = 0; i < this.attributeNames.length; ++i) {
                    if (this.attributeValues[i] == null) continue;
                    String value = env.getContext().evaluate(currentNode, this.attributeValues[i]).getStringValue();
                    if (this.attributeNames[i].startsWith("xmlns")) {
                        String prefix;
                        NamespaceName nsName2 = new NamespaceName(value);
                        if (nsName2.equals(Stylesheet.NAMESPACE) || this.extNamespaces.contains(nsName2) || this.excludedNamespaces.contains(nsName2)) continue;
                        NamespaceName resultNamespace = stylesheet.getAliasedNamespace(nsName2);
                        if (resultNamespace != null) {
                            prefix = stylesheet.getAliasedPrefix(nsName2);
                            nsName2 = resultNamespace;
                        } else {
                            int index = this.attributeNames[i].indexOf(58);
                            prefix = index != -1 ? this.attributeNames[i].substring(index + 1, this.attributeNames[i].length()) : "";
                        }
                        namespaceMap.put(nsName2, prefix);
                        continue;
                    }
                    ExpandedQName qName = new ExpandedQName(this.attributeNames[i], this.getNamespaceContext());
                    nsName = qName.getNamespaceName();
                    if (nsName.equals(Stylesheet.NAMESPACE) || this.extNamespaces.contains(nsName)) continue;
                    attributes.add(new Attribute(this.attributeNames[i], value));
                }
            }
            AxisNamespace axisNamespace = new AxisNamespace();
            axisNamespace.setup(this.getNamespaceContext(), env.getContext());
            Node namespace = axisNamespace.first();
            while (namespace != null) {
                String usePrefix;
                nsName = ((Namespace)namespace).getNamespaceName();
                if (nsName.equals(Stylesheet.NAMESPACE) || this.extNamespaces.contains(nsName) || this.excludedNamespaces.contains(nsName)) {
                    namespace = axisNamespace.next();
                    continue;
                }
                NamespaceName nsAlias = stylesheet.getAliasedNamespace(nsName);
                if (nsAlias != null) {
                    usePrefix = stylesheet.getAliasedPrefix(nsName);
                    nsName = nsAlias;
                } else {
                    usePrefix = namespace.getNodeName();
                }
                namespaceMap.put(nsName, usePrefix);
                namespace = axisNamespace.next();
            }
            String adjustedName = this.adjustPrefix(this.elementName, env, namespaceMap);
            String namespaceURI = this.getNamespaceURI(adjustedName, env);
            try {
                try {
                    result.startElement(adjustedName, namespaceURI);
                }
                catch (IllegalNameException e) {
                    env.reportError(this.getNamespaceContext(), "pe5", adjustedName);
                }
                Iterator keyIt = namespaceMap.keySet().iterator();
                while (keyIt.hasNext()) {
                    NamespaceName nsName3 = (NamespaceName)keyIt.next();
                    ProcessingEnv.resultNamespace(result, (String)namespaceMap.get(nsName3), nsName3);
                }
                if (this.attributeSets != null) {
                    this.attributeSets.instantiate(env, currentNode, result);
                }
                Iterator attrIt = attributes.iterator();
                Attribute attr = null;
                try {
                    while (attrIt.hasNext()) {
                        attr = (Attribute)attrIt.next();
                        result.attribute(this.adjustPrefix(attr.getName(), env, namespaceMap), attr.getValue());
                    }
                }
                catch (IllegalNameException e) {
                    env.reportError(this.getNamespaceContext(), "pe5", attr.getName());
                }
                this.instantiateTemplates(env, currentNode, result);
                result.endElement(adjustedName);
            }
            catch (AttributeAfterChildException e) {
                env.reportError(this.getNamespaceContext(), "pe6", "");
            }
            catch (IllegalNodeException e) {
                env.reportError(this.getNamespaceContext(), "pe7");
            }
            catch (ResultException e) {
                env.reportError(this.getNamespaceContext(), "pe8", e.getMessage());
            }
        }
        catch (XPathEvaluationException e) {
            env.reportError(this.getNamespaceContext(), "pe2", e.getMessage());
        }
    }

    protected String adjustPrefix(String name, ProcessingEnv env, Map namespaceMap) {
        int index = name.indexOf(58);
        if (index == -1) {
            return name;
        }
        String prefix = name.substring(0, index);
        NamespaceName nsName = env.getContext().getNamespaceName(prefix);
        String newPrefix = (String)namespaceMap.get(nsName);
        if (newPrefix == null) {
            newPrefix = env.getStylesheet().getAliasedPrefix(nsName);
        }
        if (newPrefix == null || newPrefix.equals(prefix)) {
            return name;
        }
        return newPrefix + ":" + name.substring(index + 1, name.length());
    }

    protected String getNamespaceURI(String name, ProcessingEnv env) {
        Node nsContext;
        String uri;
        String prefix = null;
        int index = name.indexOf(58);
        if (index != -1) {
            prefix = name.substring(0, index);
        }
        if ((uri = DOMUtil.getURIforNSPrefix(prefix, nsContext = env.getContext().getNamespaceContext())) == null) {
            uri = NamespaceName.NULL_NAMESPACE.getString();
        }
        return uri;
    }

    public void dump(PrintWriter out, int indent) {
        Util.indent(out, indent);
        out.println("literal element " + this.elementName);
        if (this.attributeNames != null) {
            for (int i = 0; i < this.attributeNames.length; ++i) {
                Util.indent(out, indent + 1);
                out.println("literal attribute " + this.attributeNames[i]);
                this.attributeValues[i].dump(out, indent + 2);
            }
        }
        super.dump(out, indent);
    }

    static class Attribute {
        private String name;
        private String value;

        public Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

