/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.process.NumberTemplate;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class MultiNumberTemplate
extends NumberTemplate {
    private static final int[] EMPTY_INT_ARRAY = new int[0];

    public MultiNumberTemplate(Pattern countPattern, Pattern fromPattern, Expression formatExpr, Expression langExpr, Expression letterValueExpr, Expression digitGroupSepExpr, Expression digitsPerGroupExpr, Node nsContext) throws XSLException {
        super(countPattern, fromPattern, formatExpr, langExpr, letterValueExpr, digitGroupSepExpr, digitsPerGroupExpr, null, nsContext);
    }

    public void instantiate(ProcessingEnv env, Node currentNode, ResultHandler result) throws XSLException {
        Trace.traceTemplate("number");
        NumberTemplate.ParsedFormat parsedFormat = this.preparsedFormat;
        String digitGroupSep = null;
        int digitsPerGroup = 0;
        try {
            if (parsedFormat == null) {
                String format = env.getContext().evaluate(currentNode, this.formatExpr).getStringValue();
                String lang = null;
                if (this.langExpr != null) {
                    lang = env.getContext().evaluate(currentNode, this.langExpr).getStringValue();
                }
                String letterValue = null;
                if (this.letterValueExpr != null) {
                    letterValue = env.getContext().evaluate(currentNode, this.letterValueExpr).getStringValue();
                }
                parsedFormat = new NumberTemplate.ParsedFormat(format, lang, letterValue);
            }
            if (this.digitGroupSepExpr != null) {
                digitGroupSep = env.getContext().evaluate(currentNode, this.digitGroupSepExpr).getStringValue();
            }
            if (this.digitsPerGroupExpr != null) {
                digitsPerGroup = (int)env.getContext().evaluate(currentNode, this.digitsPerGroupExpr).getNumberValue();
            }
            int[] counts = EMPTY_INT_ARRAY;
            for (Node node = currentNode; !(node == null || this.fromPattern != null && this.fromPattern.match(node, env.getContext())); node = node.getParentNode()) {
                Node sibling;
                int count = 0;
                if (this.countPattern != null) {
                    if (this.countPattern.match(node, env.getContext())) {
                        count = 1;
                        sibling = XPathUtil.getPreviousSibling(node);
                        while (sibling != null) {
                            if (this.countPattern.match(sibling, env.getContext())) {
                                ++count;
                            }
                            sibling = XPathUtil.getPreviousSibling(sibling);
                        }
                    }
                } else if (node.getNodeType() == 1 && currentNode.getNodeType() == 1 && node.getNodeName().equals(currentNode.getNodeName())) {
                    count = 1;
                    sibling = XPathUtil.getPreviousSibling(node);
                    while (sibling != null) {
                        if (sibling.getNodeType() == 1 && sibling.getNodeName().equals(currentNode.getNodeName())) {
                            ++count;
                        }
                        sibling = XPathUtil.getPreviousSibling(sibling);
                    }
                }
                if (count <= 0) continue;
                int[] temp = new int[counts.length + 1];
                System.arraycopy(counts, 0, temp, 1, counts.length);
                counts = temp;
                counts[0] = count;
            }
            parsedFormat.formatStart(result);
            for (int i = 0; i < counts.length; ++i) {
                parsedFormat.formatNumber(counts[i], i, digitGroupSep, digitsPerGroup, result);
            }
            parsedFormat.formatEnd(result);
        }
        catch (XPathEvaluationException e) {
            env.reportError(this.getNamespaceContext(), "pe2", e.getMessage());
        }
        catch (IllegalNodeException e) {
            env.reportError(this.getNamespaceContext(), "pe7");
        }
        catch (ResultException e) {
            env.reportError(this.getNamespaceContext(), "pe8", e.getMessage());
        }
    }

    public void dump(PrintWriter out, int indent) {
        Util.indent(out, indent);
        out.println("number level=multi");
        super.dump(out, indent + 1);
    }
}

