/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Assert;
import com.novell.xsl.number.NumberFormatter;
import com.novell.xsl.number.NumberFormatters;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.w3c.dom.Node;

public abstract class NumberTemplate
implements Template {
    protected Pattern countPattern;
    protected Pattern fromPattern;
    protected Expression formatExpr;
    protected Expression langExpr;
    protected Expression letterValueExpr;
    protected Expression digitGroupSepExpr;
    protected Expression digitsPerGroupExpr;
    protected Expression valueExpr;
    protected ParsedFormat preparsedFormat;
    private Node nsContext;

    public NumberTemplate(Pattern countPattern, Pattern fromPattern, Expression formatExpr, Expression langExpr, Expression letterValueExpr, Expression digitGroupSepExpr, Expression digitsPerGroupExpr, Expression valueExpr, Node nsContext) throws XSLException {
        this.countPattern = countPattern;
        this.fromPattern = fromPattern;
        this.formatExpr = formatExpr;
        this.langExpr = langExpr;
        this.letterValueExpr = letterValueExpr;
        this.digitGroupSepExpr = digitGroupSepExpr;
        this.digitsPerGroupExpr = digitsPerGroupExpr;
        this.valueExpr = valueExpr;
        this.nsContext = nsContext;
        if (formatExpr.isConstant() && (langExpr == null || langExpr.isConstant()) && (letterValueExpr == null || letterValueExpr.isConstant())) {
            try {
                String format = formatExpr.evaluate(null, null).getStringValue();
                String lang = langExpr == null ? null : langExpr.evaluate(null, null).getStringValue();
                String letterValue = letterValueExpr == null ? null : letterValueExpr.evaluate(null, null).getStringValue();
                this.preparsedFormat = new ParsedFormat(format, lang, letterValue);
            }
            catch (XPathEvaluationException e) {
                StringBuffer prologue = ProcessingEnv.buildMsgPrologue(null, nsContext);
                prologue.append(e.getMessage());
                throw new XSLException(prologue.toString());
            }
        } else {
            this.preparsedFormat = null;
        }
    }

    public Node getNamespaceContext() {
        return this.nsContext;
    }

    public void dump(PrintWriter out, int indent) {
        if (this.countPattern != null) {
            out.println(indent + "count");
            this.countPattern.dump(out, indent + 1);
        }
        if (this.fromPattern != null) {
            out.println(indent + "from");
            this.fromPattern.dump(out, indent + 1);
        }
        out.println(indent + "format");
        this.formatExpr.dump(out, indent + 1);
        if (this.langExpr != null) {
            out.println(indent + "xml:lang");
            this.langExpr.dump(out, indent + 1);
        }
        if (this.letterValueExpr != null) {
            out.println(indent + "letterValue");
            this.letterValueExpr.dump(out, indent + 1);
        }
        if (this.digitGroupSepExpr != null) {
            out.println(indent + "digitGroupSep");
            this.digitGroupSepExpr.dump(out, indent + 1);
        }
        if (this.digitsPerGroupExpr != null) {
            out.println(indent + "digitsPerGroup");
            this.digitsPerGroupExpr.dump(out, indent + 1);
        }
        if (this.valueExpr != null) {
            out.println(indent + "value");
            this.valueExpr.dump(out, indent + 1);
        }
        if (this.preparsedFormat != null) {
            out.println(indent + "preparsedFormat");
            this.preparsedFormat.dump(out, indent + 1);
        }
    }

    protected static final class ParsedFormat {
        private String start;
        private final String end;
        private final NumberFormatter[] formatters;
        private final String[] separators;

        public ParsedFormat(String format, String lang, String letterValue) throws XSLException {
            int i;
            ArrayList<NumberFormatter> formatterList = new ArrayList<NumberFormatter>();
            ArrayList<String> separatorList = new ArrayList<String>();
            char[] c = format.toCharArray();
            int tokenStart = 0;
            for (i = 0; i < c.length && !ParsedFormat.isAlphanumeric(c[i]); ++i) {
            }
            if (i == tokenStart) {
                this.start = null;
            } else {
                this.start = format.substring(tokenStart, i);
                tokenStart = i;
            }
            separatorList.add(".");
            if (i == c.length) {
                formatterList.add(NumberFormatters.get("1", lang, letterValue));
                this.end = this.start;
                this.start = null;
            } else {
                while (true) {
                    if (i < c.length && ParsedFormat.isAlphanumeric(c[i])) {
                        ++i;
                        continue;
                    }
                    formatterList.add(NumberFormatters.get(format.substring(tokenStart, i), lang, letterValue));
                    tokenStart = i;
                    while (i < c.length && !ParsedFormat.isAlphanumeric(c[i])) {
                        ++i;
                    }
                    if (i == c.length) {
                        if (i == tokenStart) {
                            this.end = null;
                            break;
                        }
                        this.end = format.substring(tokenStart, i);
                        break;
                    }
                    separatorList.add(format.substring(tokenStart, i));
                    tokenStart = i;
                }
            }
            this.formatters = new NumberFormatter[formatterList.size()];
            formatterList.toArray(this.formatters);
            this.separators = new String[separatorList.size()];
            separatorList.toArray(this.separators);
            Assert.assertCondition(this.formatters.length == this.separators.length, "formatters and separators out-of-sync");
        }

        private static boolean isAlphanumeric(char ch) {
            switch (Character.getType(ch)) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 10: 
                case 11: {
                    return true;
                }
            }
            return false;
        }

        public void formatStart(ResultHandler result) throws IllegalNodeException, ResultException {
            if (this.start != null) {
                result.characters(this.start);
            }
        }

        public void formatNumber(int number, int index, String digitGroupSep, int digitsPerGroup, ResultHandler result) throws IllegalNodeException, ResultException {
            if (index > 0) {
                if (index >= this.separators.length) {
                    index = this.separators.length - 1;
                }
                result.characters(this.separators[index]);
            }
            String formattedNumber = this.formatters[index].format(number);
            if (digitGroupSep != null && formattedNumber.length() > digitsPerGroup) {
                char[] digits = formattedNumber.toCharArray();
                int numDigits = formattedNumber.length();
                StringBuffer buf = new StringBuffer();
                int i = (numDigits - 1) % digitsPerGroup + 1;
                buf.append(digits, 0, i);
                do {
                    buf.append(digitGroupSep).append(digits, i, digitsPerGroup);
                } while ((i += digitsPerGroup) < numDigits);
                formattedNumber = buf.toString();
            }
            result.characters(formattedNumber);
        }

        public void formatEnd(ResultHandler result) throws IllegalNodeException, ResultException {
            if (this.end != null) {
                result.characters(this.end);
            }
        }

        public void dump(PrintWriter out, int indent) {
            if (this.start != null) {
                Util.indent(out, indent);
                out.println(XMLUtil.quote(this.start));
            }
            for (int i = 1; i < this.separators.length; ++i) {
                Util.indent(out, indent);
                out.println(XMLUtil.quote(this.separators[i]));
                Util.indent(out, indent);
                out.println(this.formatters[i].getClass().getName());
            }
            Util.indent(out, indent);
            out.println(this.formatters[this.formatters.length].getClass().getName());
            if (this.end != null) {
                Util.indent(out, indent);
                out.println(XMLUtil.quote(this.end));
            }
        }
    }
}

