/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateCollection;
import com.novell.xsl.result.IllegalNameException;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.result.TextResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class PITemplate
extends TemplateCollection {
    private final Expression name;

    public PITemplate(Expression name, Template[] templates, Node nsNode) {
        super(templates, nsNode);
        this.name = name;
    }

    public void instantiate(ProcessingEnv env, Node currentNode, ResultHandler result) throws XSLException {
        String targetName;
        Trace.traceTemplate("processing-instruction");
        try {
            targetName = env.getContext().evaluate(currentNode, this.name).getStringValue();
        }
        catch (XPathEvaluationException e) {
            env.reportError(this.getNamespaceContext(), "pe2", e.getMessage());
            return;
        }
        if (!XMLUtil.isNCName(targetName) || !XMLUtil.isPITarget(targetName)) {
            env.reportError(this.getNamespaceContext(), "pe5", targetName);
            return;
        }
        TextResultHandler textResult = new TextResultHandler();
        this.instantiateTemplates(env, currentNode, textResult);
        String value = textResult.getText();
        int i = value.lastIndexOf("?>");
        if (i > 0) {
            env.reportError(this.getNamespaceContext(), "pe10");
            StringBuffer buf = new StringBuffer(value);
            do {
                buf.insert(i + 1, ' ');
            } while ((i = value.lastIndexOf("?>", i - 2)) > 0);
            value = buf.toString();
        }
        try {
            result.processingInstruction(targetName, value);
        }
        catch (IllegalNameException e) {
            env.reportError(this.getNamespaceContext(), "pe5", targetName);
        }
        catch (IllegalNodeException e) {
            env.reportError(this.getNamespaceContext(), "pe7");
        }
        catch (ResultException e) {
            env.reportError(this.getNamespaceContext(), "pe8", e.getMessage());
        }
    }

    public void dump(PrintWriter out, int indent) {
        Util.indent(out, indent);
        out.println("processing-instruction");
        Util.indent(out, indent + 1);
        out.println("name");
        this.name.dump(out, indent + 2);
        super.dump(out, indent);
    }
}

