/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.xpath.NumberValue;
import java.math.BigDecimal;

public final class Priority
extends BigDecimal {
    private static final Priority[] COMMON_VALUES = new Priority[]{new Priority("-0.5"), new Priority("-0.25"), new Priority("0"), new Priority(".5"), new Priority("1"), new Priority("2")};

    private Priority(String value) {
        super(value);
    }

    private Priority(double value) {
        super(NumberValue.getStringValue(value));
    }

    public static Priority create(String value) {
        if ("2".equals(value)) {
            return COMMON_VALUES[5];
        }
        if ("1".equals(value)) {
            return COMMON_VALUES[4];
        }
        if ("0.5".equals(value)) {
            return COMMON_VALUES[3];
        }
        if ("0".equals(value)) {
            return COMMON_VALUES[2];
        }
        if ("-0.25".equals(value)) {
            return COMMON_VALUES[1];
        }
        if ("-0.5".equals(value)) {
            return COMMON_VALUES[0];
        }
        return new Priority(value);
    }

    public static Priority create(double value) {
        if (value == 2.0) {
            return COMMON_VALUES[5];
        }
        if (value == 1.0) {
            return COMMON_VALUES[4];
        }
        if (value == 0.5) {
            return COMMON_VALUES[3];
        }
        if (value == 0.0) {
            return COMMON_VALUES[2];
        }
        if (value == -0.25) {
            return COMMON_VALUES[1];
        }
        if (value == -0.5) {
            return COMMON_VALUES[0];
        }
        return new Priority(value);
    }
}

