/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.NodeImpl;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xsl.ErrorHandler;
import com.novell.xsl.MessageHandler;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.Context;
import com.novell.xsl.process.Mode;
import com.novell.xsl.process.ProcessException;
import com.novell.xsl.process.Rule;
import com.novell.xsl.process.TemplateRule;
import com.novell.xsl.process.VariableTemplate;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProcessingEnv {
    private static final int INITIAL_NODE_MODE_SIZE = 8;
    private Stylesheet stylesheet;
    private Context context;
    private ErrorHandler errorHandler;
    private MessageHandler messageHandler;
    private Node[] nodeStack = new Node[8];
    private Mode[] modeStack = new Mode[8];
    private int[] importanceStack = new int[8];
    private ResultHandler topLevelResultHandler;
    private int stackSize = 0;
    private Map parameters = new HashMap();
    private Stack parameterStack = new Stack();
    private List variables = null;
    private Stack variableStack = new Stack();
    private Stack currentRuleStack = new Stack();
    private Document nodeFactory;

    public ProcessingEnv(Stylesheet stylesheet, Context context, Document nodeFactory, ErrorHandler errorHandler, MessageHandler messageHandler, ResultHandler topLevelResultHandler) {
        this.stylesheet = stylesheet;
        this.context = context;
        this.nodeFactory = nodeFactory;
        this.errorHandler = errorHandler;
        this.messageHandler = messageHandler;
        this.topLevelResultHandler = topLevelResultHandler;
    }

    public ProcessingEnv(ProcessingEnv iVal) {
        this(iVal.stylesheet, new Context(iVal.context), iVal.nodeFactory, iVal.errorHandler, iVal.messageHandler, iVal.topLevelResultHandler);
        this.nodeStack = (Node[])iVal.nodeStack.clone();
        this.modeStack = (Mode[])iVal.modeStack.clone();
        this.importanceStack = (int[])iVal.importanceStack.clone();
        this.stackSize = iVal.stackSize;
        this.parameters = new HashMap(iVal.parameters);
        this.parameterStack = (Stack)iVal.parameterStack.clone();
        this.currentRuleStack = (Stack)iVal.currentRuleStack.clone();
        if (iVal.variables != null) {
            this.variables = new ArrayList(iVal.variables);
        }
        this.variableStack = (Stack)iVal.variableStack.clone();
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public Context getContext() {
        return this.context;
    }

    public void process(Node source, Mode mode, ResultHandler result) throws XSLException {
        Trace.traceSource(source, mode);
        Rule rule = this.stylesheet.getTemplateRules().findMatchingRule(source, this, mode);
        if (rule != null) {
            this.processWithRule(source, mode, result, rule);
        }
    }

    public void processWithImports(Node source, ResultHandler result) throws XSLException {
        Trace.traceSource(source, this.getCurrentRule().getMode());
        Rule rule = this.stylesheet.getTemplateRules().findMatchingImportedRule(source, this, this.getCurrentRule());
        if (rule != null) {
            this.processWithRule(source, this.getCurrentRule().getMode(), result, rule);
        }
    }

    public void processWithRule(Node source, Mode mode, ResultHandler result, Rule rule) throws XSLException {
        int importance = rule.getImportance();
        for (int i = this.stackSize - 1; i >= 0; --i) {
            if (this.nodeStack[i] != source || this.modeStack[i] != mode || this.importanceStack[i] != importance) continue;
            this.reportError(ProcessException.constructMessage("pe12", new String[]{mode == Mode.DEFAULT_MODE ? "" : mode.getName().getQName(), DOMUtil.describeNode(source)}));
            return;
        }
        if (this.stackSize == this.nodeStack.length) {
            Node[] temp1 = new Node[this.stackSize * 2];
            Mode[] temp2 = new Mode[this.stackSize * 2];
            int[] temp3 = new int[this.stackSize * 2];
            System.arraycopy(this.nodeStack, 0, temp1, 0, this.stackSize);
            System.arraycopy(this.modeStack, 0, temp2, 0, this.stackSize);
            System.arraycopy(this.importanceStack, 0, temp3, 0, this.stackSize);
            this.nodeStack = temp1;
            this.modeStack = temp2;
            this.importanceStack = temp3;
        }
        this.nodeStack[this.stackSize] = source;
        this.modeStack[this.stackSize] = mode;
        this.importanceStack[this.stackSize] = importance;
        ++this.stackSize;
        this.pushCurrentRule(rule);
        ((TemplateRule)rule).instantiate(this, source, mode, result);
        this.popCurrentRule();
        --this.stackSize;
    }

    public Stylesheet getStylesheet() {
        return this.stylesheet;
    }

    public void bindParameter(ExpandedQName name, ExpressionValue value) {
        this.parameters.remove(name);
        this.parameters.put(name, value);
    }

    public ExpressionValue getParameter(ExpandedQName name) {
        return (ExpressionValue)this.parameters.get(name);
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public void pushParameters() {
        this.parameterStack.push(new HashMap(this.parameters));
        this.clearParameters();
    }

    public void popParameters() {
        this.parameters = (Map)this.parameterStack.pop();
    }

    public void setVariable(VariableTemplate variable) {
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        this.variables.add(new LocalVariable(variable));
    }

    public void pushVariables() {
        this.variableStack.push(this.variables);
        this.variables = null;
    }

    public void popVariables() {
        this.variables = (List)this.variableStack.pop();
        if (this.variables != null) {
            Iterator it = this.variables.iterator();
            while (it.hasNext()) {
                ((LocalVariable)it.next()).restore();
            }
        }
    }

    public ResultHandler getTopLevelResultHandler() {
        return this.topLevelResultHandler;
    }

    public Rule getCurrentRule() {
        return this.currentRuleStack.empty() ? null : (Rule)this.currentRuleStack.peek();
    }

    public void pushCurrentRule(Rule rule) {
        this.currentRuleStack.push(rule);
    }

    public Rule popCurrentRule() {
        return (Rule)this.currentRuleStack.pop();
    }

    public Document getNodeFactory() {
        return this.nodeFactory;
    }

    public void setNodeFactory(Document nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public static void resultNamespace(ResultHandler result, String prefix, NamespaceName nsName) throws ResultException {
        if (!nsName.equals(NamespaceName.XML_NAMESPACE)) {
            result.namespace(prefix, nsName);
        }
    }

    public void reportError(String msg) throws XSLException {
        try {
            this.errorHandler.error(msg);
        }
        catch (XSLException e) {
            throw new ProcessException(e.getMessage());
        }
    }

    public void reportError(Node contextNode, String key) throws XSLException {
        this.reportError(contextNode, key, (Object[])null);
    }

    public void reportError(Node contextNode, String key, String parm0) throws XSLException {
        this.reportError(contextNode, key, new String[]{parm0});
    }

    public void reportError(Node contextNode, String key, String parm0, String parm1) throws XSLException {
        this.reportError(contextNode, key, new String[]{parm0, parm1});
    }

    public void reportError(Node contextNode, String key, Object[] parms) throws XSLException {
        StringBuffer prologue = ProcessingEnv.buildMsgPrologue(null, contextNode);
        String msg = ProcessException.constructMessage(key, parms);
        prologue.append(msg);
        this.reportError(prologue.toString());
    }

    public void reportWarning(Node contextNode, String key, Object[] parms) {
        StringBuffer prologue = ProcessingEnv.buildMsgPrologue(null, contextNode);
        String msg = ProcessException.constructMessage(key, parms);
        prologue.append(msg);
        this.errorHandler.warning(prologue.toString());
    }

    public static StringBuffer buildMsgPrologue(StringBuffer prologue, Node contextNode) {
        if (prologue == null) {
            prologue = new StringBuffer();
        }
        if (contextNode == null) {
            return prologue;
        }
        if (contextNode instanceof NodeImpl) {
            String uri = ((NodeImpl)contextNode).getBaseURI();
            prologue.append(uri);
            if (((NodeImpl)contextNode).getLineNumber() != -1) {
                prologue.append(" (");
                prologue.append(((NodeImpl)contextNode).getLineNumber());
                prologue.append(')');
            }
            prologue.append(": ");
        }
        Node elementNode = contextNode;
        if (contextNode.getNodeType() != 1) {
            elementNode = contextNode.getParentNode();
        }
        if (elementNode != null && elementNode.getNodeType() == 1) {
            prologue.append('<');
            prologue.append(((Element)elementNode).getTagName());
            prologue.append(">: ");
        }
        return prologue;
    }

    static class LocalVariable {
        private VariableTemplate variable;
        private ExpressionValue value;

        LocalVariable(VariableTemplate variable) {
            this.variable = variable;
            this.value = variable.getCurrentValue();
        }

        void restore() {
            this.variable.setCurrentValue(this.value);
        }
    }
}

