/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.process.Mode;
import com.novell.xsl.process.Priority;
import com.novell.xsl.process.ProcessingEnv;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public abstract class Rule
implements Comparable {
    private Pattern pattern;
    private ExpandedQName name;
    private Mode mode;
    private int importance;
    private Priority priority;
    private int number;
    private Node nsContext;

    public Rule(Pattern pattern, ExpandedQName name, Mode mode, int importance, Priority priority, int number, Node nsContext) {
        this.pattern = pattern;
        this.name = name;
        this.mode = mode;
        this.importance = importance;
        this.priority = priority == null ? (pattern != null ? Priority.create(pattern.getDefaultPriority()) : Priority.create(0.0)) : priority;
        this.number = number;
        this.nsContext = nsContext;
    }

    protected Rule(Rule original, Pattern pattern) {
        this.pattern = pattern;
        this.name = original.name;
        this.mode = original.mode;
        this.importance = original.importance;
        this.priority = original.priority;
        this.number = original.number;
        this.nsContext = original.nsContext;
    }

    public abstract Rule cloneForUnion(Pattern var1);

    public abstract void dump(PrintWriter var1, int var2);

    public Pattern getPattern() {
        return this.pattern;
    }

    public ExpandedQName getName() {
        return this.name;
    }

    public Mode getMode() {
        return this.mode;
    }

    public int getImportance() {
        return this.importance;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public int getNumber() {
        return this.number;
    }

    public int compareTo(Object obj) {
        Rule rule = (Rule)obj;
        if (this.importance != rule.importance) {
            return rule.importance - this.importance;
        }
        int i = rule.priority.compareTo(this.priority);
        if (i != 0) {
            return i;
        }
        return rule.number - this.number;
    }

    public boolean matches(Node source, ProcessingEnv env, Mode mode) throws XSLException {
        if (this.mode == mode || this.mode == Mode.ANY_MODE) {
            Trace.traceMatch(" mode+");
            try {
                return this.pattern.match(source, env.getContext());
            }
            catch (XPathEvaluationException e) {
                env.reportError(this.getNamespaceContext(), "pe2", e.getMessage());
            }
        }
        Trace.traceMatch(" mode-");
        return false;
    }

    public Node getNamespaceContext() {
        return this.nsContext;
    }

    protected static void indent(PrintWriter writer, int indent) {
        for (int i = 0; i < indent; ++i) {
            writer.print("\t");
        }
    }
}

