/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.process.Mode;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Rule;
import com.novell.xsl.process.RuleList;
import com.novell.xsl.process.RuleMap;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;

public class RuleCollection {
    private RuleList rootRules = new RuleList();
    private RuleMap elementRules = new RuleMap();
    private RuleList attributeRules = new RuleList();
    private RuleList otherRules = new RuleList();
    private Map namedRules = new HashMap();
    private Rule[] builtInRules;
    private boolean isOptimized = false;

    public RuleCollection() {
        int maxNodeType = 2;
        if (maxNodeType < 4) {
            maxNodeType = 4;
        }
        if (maxNodeType < 8) {
            maxNodeType = 8;
        }
        if (maxNodeType < 11) {
            maxNodeType = 11;
        }
        if (maxNodeType < 9) {
            maxNodeType = 9;
        }
        if (maxNodeType < 10) {
            maxNodeType = 10;
        }
        if (maxNodeType < 1) {
            maxNodeType = 1;
        }
        if (maxNodeType < 6) {
            maxNodeType = 6;
        }
        if (maxNodeType < 5) {
            maxNodeType = 5;
        }
        if (maxNodeType < 12) {
            maxNodeType = 12;
        }
        if (maxNodeType < 7) {
            maxNodeType = 7;
        }
        if (maxNodeType < 3) {
            maxNodeType = 3;
        }
        this.builtInRules = new Rule[maxNodeType];
    }

    public void add(Rule rule) {
        this.unoptimize();
        Pattern pattern = rule.getPattern();
        ExpandedQName name = rule.getName();
        if (name != null) {
            Rule oldRule = this.getNamedRule(name);
            if (oldRule != null) {
                if (oldRule.getImportance() <= rule.getImportance()) {
                    this.namedRules.remove(name);
                    this.namedRules.put(name, rule);
                }
            } else {
                this.namedRules.put(name, rule);
            }
        }
        if (pattern != null) {
            switch (pattern.getTarget()) {
                case 0: {
                    this.rootRules.add(rule);
                    break;
                }
                case 1: {
                    this.elementRules.addNamed(pattern.getTargetName(), rule);
                    break;
                }
                case 2: {
                    this.elementRules.addWildcard(rule);
                    break;
                }
                case 3: 
                case 4: {
                    this.attributeRules.add(rule);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    this.otherRules.add(rule);
                    break;
                }
                default: {
                    this.rootRules.add(rule);
                    this.elementRules.addWildcard(rule);
                    this.attributeRules.add(rule);
                    this.otherRules.add(rule);
                }
            }
        }
        if (name == null && pattern == null) {
            throw new IllegalArgumentException("RuleCollection: Rule with no pattern and no name");
        }
    }

    public void setBuiltIn(Rule rule, int nodeType) {
        if (nodeType == 9) {
            this.builtInRules[11] = rule;
        }
        this.builtInRules[nodeType] = rule;
    }

    public Rule findMatchingRule(Node source, ProcessingEnv env, Mode mode) throws XSLException {
        return this.matchNode(source, env, mode, null);
    }

    public Rule findMatchingImportedRule(Node source, ProcessingEnv env, Rule currentRule) throws XSLException {
        if (currentRule == null) {
            throw new IllegalArgumentException("null currentRule argument to findMatchingImportedRule()");
        }
        return this.matchNode(source, env, currentRule.getMode(), currentRule);
    }

    public Rule getNamedRule(ExpandedQName name) {
        return (Rule)this.namedRules.get(name);
    }

    public void optimize() {
        if (!this.isOptimized) {
            this.rootRules.optimize();
            this.elementRules.optimize();
            this.isOptimized = true;
        }
    }

    public void dump(PrintWriter out, int indent) {
        int i;
        for (i = 0; i < indent; ++i) {
            out.print("\t");
        }
        out.println("built-in rules");
        for (i = 0; i < this.builtInRules.length; ++i) {
            if (this.builtInRules[i] == null) continue;
            this.builtInRules[i].dump(out, indent + 1);
        }
        out.println(indent + "rules");
        out.println(indent + "root rules");
        this.rootRules.dump(out, indent + 1);
        out.println(indent + "element rules");
        this.elementRules.dump(out, indent + 1);
        out.println(indent + "attribute rules");
        this.attributeRules.dump(out, indent + 1);
        out.println(indent + "other rules");
        this.otherRules.dump(out, indent + 1);
    }

    private void unoptimize() {
        if (this.isOptimized) {
            this.isOptimized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rule matchNode(Node source, ProcessingEnv env, Mode mode, Rule currentRule) throws XSLException {
        int i;
        Rule[] ruleArray;
        if (!this.isOptimized) {
            this.optimize();
        }
        switch (source.getNodeType()) {
            case 9: {
                ruleArray = this.rootRules.getRules();
                break;
            }
            case 1: {
                ExpandedQName expandedName = DOMUtil.getExpandedName(source);
                ruleArray = this.elementRules.getRules(expandedName);
                break;
            }
            case 2: {
                ruleArray = this.attributeRules.getRules();
                break;
            }
            default: {
                ruleArray = this.otherRules.getRules();
            }
        }
        if (currentRule != null) {
            int currentImportance = currentRule.getImportance();
            for (i = 0; i < ruleArray.length && currentImportance <= ruleArray[i].getImportance(); ++i) {
            }
            if (i >= ruleArray.length) {
                return null;
            }
        }
        env.getContext().pushState();
        try {
            while (i < ruleArray.length) {
                Rule rule = ruleArray[i];
                Trace.traceRuleBegin(rule);
                env.getContext().setNamespaceContext(rule.getNamespaceContext());
                boolean matches = rule.matches(source, env, mode);
                if (matches) {
                    Trace.traceRuleEnd(rule);
                    Rule rule2 = rule;
                    return rule2;
                }
                Trace.traceRuleEnd(null);
                ++i;
            }
        }
        finally {
            env.getContext().popState();
        }
        if (currentRule != null) {
            return null;
        }
        Rule rule = this.builtInRules[source.getNodeType()];
        Trace.traceRuleBuiltIn(rule);
        return rule;
    }
}

