/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xsl.process.Rule;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class RuleList {
    private List ruleList = new ArrayList();
    private Rule[] ruleArray;

    public void add(Rule rule) {
        this.unoptimize();
        this.ruleList.add(rule);
    }

    public void addAll(RuleList list) {
        this.unoptimize();
        list.unoptimize();
        this.ruleList.addAll(list.ruleList);
    }

    public void removeAll(RuleList list) {
        this.unoptimize();
        list.unoptimize();
        this.ruleList.removeAll(list.ruleList);
    }

    public Rule[] getRules() {
        if (this.ruleArray == null) {
            this.optimize();
        }
        return this.ruleArray;
    }

    public void optimize() {
        if (this.ruleArray == null) {
            Collections.sort(this.ruleList);
            this.ruleArray = new Rule[this.ruleList.size()];
            this.ruleList.toArray(this.ruleArray);
            this.ruleList = null;
        }
    }

    public void dump(PrintWriter out, int indent) {
        ArrayList<Rule> list = this.ruleList;
        if (list == null) {
            list = new ArrayList<Rule>(Arrays.asList(this.ruleArray));
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                int i2;
                int i1 = ((Rule)o1).getNumber();
                if (i1 < (i2 = ((Rule)o2).getNumber())) {
                    return -1;
                }
                if (i1 > i2) {
                    return 1;
                }
                return 0;
            }
        });
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Rule rule = (Rule)i.next();
            rule.dump(out, indent);
        }
    }

    private void unoptimize() {
        if (this.ruleList == null) {
            this.ruleList = new ArrayList<Rule>(Arrays.asList(this.ruleArray));
            this.ruleArray = null;
        }
    }
}

