/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.ExpandedQName;
import com.novell.xsl.process.Rule;
import com.novell.xsl.process.RuleList;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class RuleMap {
    private HashMap hashMap = new HashMap();
    private RuleList wildcardRules = new RuleList();
    private boolean isOptimized = false;

    public void addNamed(ExpandedQName targetName, Rule rule) {
        this.unoptimize();
        RuleList ruleList = (RuleList)this.hashMap.get(targetName);
        if (ruleList == null) {
            ruleList = new RuleList();
            this.hashMap.put(targetName, ruleList);
        }
        ruleList.add(rule);
    }

    public void addWildcard(Rule rule) {
        this.unoptimize();
        this.wildcardRules.add(rule);
    }

    public Rule[] getRules(ExpandedQName targetName) {
        RuleList ruleList;
        if (!this.isOptimized) {
            this.optimize();
        }
        if ((ruleList = (RuleList)this.hashMap.get(targetName)) == null) {
            return this.wildcardRules.getRules();
        }
        return ruleList.getRules();
    }

    public void optimize() {
        if (!this.isOptimized) {
            Iterator i = this.hashMap.values().iterator();
            while (i.hasNext()) {
                RuleList ruleList = (RuleList)i.next();
                ruleList.addAll(this.wildcardRules);
                ruleList.optimize();
            }
            this.wildcardRules.optimize();
            this.isOptimized = true;
        }
    }

    public void dump(PrintWriter out, int indent) {
        boolean wasOptimized = this.isOptimized;
        this.unoptimize();
        this.wildcardRules.dump(out, indent);
        ArrayList<Rule> masterList = new ArrayList<Rule>();
        Iterator<Object> i = this.hashMap.values().iterator();
        while (i.hasNext()) {
            Rule[] rules = ((RuleList)i.next()).getRules();
            for (int j = 0; j < rules.length; ++j) {
                masterList.add(rules[j]);
            }
        }
        Collections.sort(masterList, new Comparator(){

            public int compare(Object o1, Object o2) {
                int i2;
                int i1 = ((Rule)o1).getNumber();
                if (i1 < (i2 = ((Rule)o2).getNumber())) {
                    return -1;
                }
                if (i1 > i2) {
                    return 1;
                }
                return 0;
            }
        });
        i = masterList.iterator();
        while (i.hasNext()) {
            ((Rule)i.next()).dump(out, indent);
        }
        if (wasOptimized) {
            this.optimize();
        }
    }

    private void unoptimize() {
        if (this.isOptimized) {
            Iterator i = this.hashMap.values().iterator();
            while (i.hasNext()) {
                RuleList ruleList = (RuleList)i.next();
                ruleList.removeAll(this.wildcardRules);
            }
            this.isOptimized = false;
        }
    }
}

