/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.ContextNodeList;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Assert;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.CurrentNodeList;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.SortKey;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.w3c.dom.Node;

public class SortCriteria {
    private SortKey[] sortKeys;
    private Node contextNode;

    public SortCriteria(SortKey[] sortKeys, Node contextNode) {
        this.sortKeys = sortKeys;
        this.contextNode = contextNode;
    }

    public ContextNodeList sort(ProcessingEnv env, Node currentNode, ContextNodeList nodeList) throws XSLException {
        try {
            int keyCount = this.sortKeys.length;
            EvaluatedSortKey[] evaluatedSortKeys = new EvaluatedSortKey[keyCount];
            for (int i = 0; i < keyCount; ++i) {
                Locale locale;
                SortKey sortKey = this.sortKeys[i];
                String lang = null;
                if (sortKey.getLangExpr() != null) {
                    lang = env.getContext().evaluate(currentNode, sortKey.getLangExpr()).getStringValue();
                }
                try {
                    locale = Util.parseLang(lang);
                }
                catch (IllegalArgumentException e) {
                    env.reportError(this.contextNode, "pe18", lang);
                    locale = Locale.getDefault();
                }
                boolean isDescending = false;
                if (sortKey.getOrderExpr() != null) {
                    String order = sortKey.getOrderExpr().evaluate(currentNode, env.getContext()).getStringValue();
                    if ("descending".equals(order)) {
                        isDescending = true;
                    } else if (!"ascending".equals(order)) {
                        env.reportError(this.contextNode, "pe14", XMLUtil.quote(order));
                    }
                }
                if (sortKey.getDataTypeExpr() != null) {
                    String dataType = env.getContext().evaluate(currentNode, sortKey.getDataTypeExpr()).getStringValue();
                    if ("number".equals(dataType)) {
                        evaluatedSortKeys[i] = new NumberKey(sortKey.getSelect(), isDescending);
                        continue;
                    }
                    if (!"text".equals(dataType)) {
                        if (XMLUtil.isQName(dataType) && dataType.indexOf(58) != -1) {
                            env.reportWarning(this.contextNode, "pe19", new String[]{XMLUtil.quote(dataType)});
                        } else {
                            env.reportError(this.contextNode, "pe15", XMLUtil.quote(dataType));
                        }
                    }
                }
                boolean upperIsFirst = false;
                if (sortKey.getCaseOrderExpr() != null) {
                    String caseOrder = env.getContext().evaluate(currentNode, sortKey.getCaseOrderExpr()).getStringValue();
                    if ("upper-first".equals(caseOrder)) {
                        upperIsFirst = true;
                    } else if (!"lower-first".equals(caseOrder)) {
                        env.reportError(this.contextNode, "pe16", XMLUtil.quote(caseOrder));
                    }
                }
                evaluatedSortKeys[i] = new TextKey(sortKey.getSelect(), locale, isDescending, upperIsFirst);
            }
            int nodeCount = nodeList.count();
            Object[] adapters = new ComparableAdapter[nodeCount];
            Node node = nodeList.first();
            int i = 0;
            while (node != null) {
                adapters[i++] = new ComparableAdapter(node, env.getContext(), evaluatedSortKeys);
                node = nodeList.next();
            }
            Arrays.sort(adapters);
            CurrentNodeList result = new CurrentNodeList();
            for (i = 0; i < nodeCount; ++i) {
                result.add(((ComparableAdapter)adapters[i]).node);
            }
            return result;
        }
        catch (XPathEvaluationException e) {
            env.reportError(this.contextNode, "pe2", e.getMessage());
            return nodeList;
        }
        catch (RuntimeException e) {
            env.reportError(e.getMessage());
            return nodeList;
        }
    }

    public void dump(PrintWriter out, int indent) {
        for (int i = 0; i < this.sortKeys.length; ++i) {
            this.sortKeys[i].dump(out, indent);
        }
    }

    private static class ComparableAdapter
    implements Comparable {
        Node node;
        ExpressionContext context;
        private EvaluatedSortKey[] evaluatedSortKeys;
        private Object[] cachedValues;

        public ComparableAdapter(Node node, ExpressionContext context, EvaluatedSortKey[] evaluatedSortKeys) {
            this.node = node;
            this.context = context;
            this.evaluatedSortKeys = evaluatedSortKeys;
            this.cachedValues = new Object[evaluatedSortKeys.length];
        }

        public int compareTo(Object obj) {
            ComparableAdapter other = (ComparableAdapter)obj;
            Assert.assertCondition(this.evaluatedSortKeys == other.evaluatedSortKeys, "adapters have different sort keys");
            try {
                int result = 0;
                for (int i = 0; i < this.evaluatedSortKeys.length && result == 0; ++i) {
                    if (this.cachedValues[i] == null) {
                        this.cachedValues[i] = this.evaluatedSortKeys[i].evaluateKeyValue(this.node, this.context);
                    }
                    if (other.cachedValues[i] == null) {
                        other.cachedValues[i] = other.evaluatedSortKeys[i].evaluateKeyValue(other.node, this.context);
                    }
                    result = this.evaluatedSortKeys[i].compare(this.cachedValues[i], other.cachedValues[i]);
                }
                return result;
            }
            catch (XPathEvaluationException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    private static class TextKey
    implements EvaluatedSortKey {
        private Expression select;
        private Collator collator;
        private boolean isDescending;
        private boolean upperIsFirst;

        public TextKey(Expression select, Locale locale, boolean isDescending, boolean upperIsFirst) {
            this.select = select;
            this.collator = Collator.getInstance(locale);
            this.isDescending = isDescending;
            this.upperIsFirst = upperIsFirst;
        }

        public int compare(Object obj1, Object obj2) {
            int result = ((CollationKey)obj1).compareTo((CollationKey)obj2);
            return this.isDescending ? -result : result;
        }

        public Object evaluateKeyValue(Node node, ExpressionContext context) throws XPathEvaluationException {
            Trace.traceSortKey("Text key");
            ExpressionValue value = context.evaluate(node, this.select);
            Trace.traceSelect(this.select, value);
            String str = value.getStringValue();
            if (this.upperIsFirst) {
                char[] ch = str.toCharArray();
                for (int i = ch.length - 1; i >= 0; --i) {
                    char c = ch[i];
                    if (Character.isLowerCase(c)) {
                        ch[i] = Character.toUpperCase(c);
                        continue;
                    }
                    if (!Character.isUpperCase(c)) continue;
                    ch[i] = Character.toLowerCase(c);
                }
                str = new String(ch);
            }
            return this.collator.getCollationKey(str);
        }
    }

    private static class NumberKey
    implements EvaluatedSortKey {
        private Expression select;
        private boolean isDescending;

        public NumberKey(Expression select, boolean isDescending) {
            this.select = select;
            this.isDescending = isDescending;
        }

        public int compare(Object obj1, Object obj2) {
            double diff;
            Double d1 = (Double)obj1;
            Double d2 = (Double)obj2;
            int result = d1.isNaN() ? (d2.isNaN() ? 0 : -1) : (d2.isNaN() ? 1 : ((diff = d1 - d2) < 0.0 ? -1 : (diff > 0.0 ? 1 : 0)));
            return this.isDescending ? -result : result;
        }

        public Object evaluateKeyValue(Node node, ExpressionContext context) throws XPathEvaluationException {
            Trace.traceSortKey("Numeric key");
            ExpressionValue value = context.evaluate(node, this.select);
            Trace.traceSelect(this.select, value);
            return new Double(value.getNumberValue());
        }
    }

    private static interface EvaluatedSortKey
    extends Comparator {
        public Object evaluateKeyValue(Node var1, ExpressionContext var2) throws XPathEvaluationException;
    }
}

