/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xsl.process.ElementMatch;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StripList {
    private List matchList = new ArrayList();
    private ElementMatch[] matchArray = null;

    public void add(ElementMatch match) {
        this.unoptimize();
        this.matchList.add(match);
    }

    public void clear() {
        if (this.matchArray != null || this.matchList.size() > 0) {
            this.matchList = new ArrayList();
            this.matchArray = null;
        }
    }

    public int size() {
        if (this.matchArray != null) {
            return this.matchArray.length;
        }
        return this.matchList.size();
    }

    public ElementMatch[] getList() {
        if (this.matchArray == null) {
            this.optimize();
        }
        return this.matchArray;
    }

    public boolean checkStrip(Node node) {
        if (node != null && node.getNodeType() == 1) {
            ElementMatch[] list = this.getList();
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].matches((Element)node)) continue;
                return list[i].isStrip();
            }
        }
        return false;
    }

    public void dump(PrintWriter out, int indent) {
        ArrayList<ElementMatch> list = this.matchList;
        if (list == null) {
            list = new ArrayList<ElementMatch>(Arrays.asList(this.matchArray));
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                int i1 = ((ElementMatch)o1).getNumber();
                int i2 = ((ElementMatch)o2).getNumber();
                return i1 - i2;
            }
        });
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ElementMatch match = (ElementMatch)i.next();
            match.dump(out, indent);
        }
    }

    public void optimize() {
        if (this.matchArray == null) {
            Collections.sort(this.matchList);
            this.matchArray = new ElementMatch[this.matchList.size()];
            this.matchList.toArray(this.matchArray);
            this.matchList = null;
        }
    }

    private void unoptimize() {
        if (this.matchList == null) {
            this.matchList = new ArrayList<ElementMatch>(Arrays.asList(this.matchArray));
            this.matchArray = null;
        }
    }
}

