/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xsl.XSLException;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.process.Mode;
import com.novell.xsl.process.Priority;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Rule;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.VariableTemplate;
import com.novell.xsl.result.ResultHandler;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import org.w3c.dom.Node;

public class TemplateRule
extends Rule {
    private Template[] templates;
    private Collection variables;
    protected RecursionCounter recursionLevel;

    public TemplateRule(Pattern pattern, ExpandedQName name, Template[] templates, Collection variables, Mode mode, int importance, Priority priority, int number, Node nsContext) {
        super(pattern, name, mode, importance, priority, number, nsContext);
        this.recursionLevel = new RecursionCounter();
        this.templates = templates;
        this.variables = variables;
    }

    protected TemplateRule(TemplateRule original, Pattern pattern) {
        super(original, pattern);
        this.recursionLevel = original.recursionLevel;
        this.templates = original.templates;
        this.variables = original.variables;
    }

    public Template[] getTemplates() {
        return this.templates;
    }

    public Rule cloneForUnion(Pattern pattern) {
        return new TemplateRule(this, pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instantiate(ProcessingEnv env, Node currentNode, Mode currentMode, ResultHandler result) throws XSLException {
        if (this.templates != null) {
            env.getContext().pushState();
            ExpressionValue[] state = this.pushVariables();
            this.recursionLevel.increment();
            try {
                for (int i = 0; i < this.templates.length; ++i) {
                    env.getContext().setNamespaceContext(this.templates[i].getNamespaceContext());
                    this.templates[i].instantiate(env, currentNode, result);
                }
                Object var8_7 = null;
                this.recursionLevel.decrement();
                this.popVariables(state);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.recursionLevel.decrement();
                this.popVariables(state);
                env.getContext().popState();
                throw throwable;
            }
            env.getContext().popState();
            {
            }
        }
    }

    protected ExpressionValue[] pushVariables() {
        if (this.recursionLevel.getLevel() > 0 && this.variables != null) {
            ExpressionValue[] state = new ExpressionValue[this.variables.size()];
            Iterator it = this.variables.iterator();
            int i = 0;
            while (it.hasNext()) {
                state[i++] = ((VariableTemplate)it.next()).getCurrentValue();
            }
            return state;
        }
        return null;
    }

    protected void popVariables(ExpressionValue[] state) {
        if (state != null) {
            Iterator it = this.variables.iterator();
            int i = 0;
            while (it.hasNext()) {
                ((VariableTemplate)it.next()).setCurrentValue(state[i++]);
            }
        }
    }

    public void dump(PrintWriter out, int indent) {
        Rule.indent(out, indent);
        out.println("(" + this.getNumber() + ") mode=" + this.getMode().getName() + " importance=" + this.getImportance() + " priority=" + this.getPriority());
        out.println(indent + "    match pattern");
        this.getPattern().dump(out, indent + 1);
        out.println(indent + "    templates");
        if (this.templates != null) {
            for (int i = 0; i < this.templates.length; ++i) {
                this.templates[i].dump(out, indent + 1);
            }
        }
    }

    protected static class RecursionCounter {
        private int level = 0;

        protected RecursionCounter() {
        }

        void increment() {
            ++this.level;
        }

        void decrement() {
            --this.level;
        }

        int getLevel() {
            return this.level;
        }
    }
}

