/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.XMLUtil;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.result.Serializer;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class TextTemplate
implements Template {
    private final String text;
    private final boolean noEscaping;
    private final Node nsContext;

    public TextTemplate(String text, boolean noEscaping, Node nsContext) {
        this.text = text;
        this.noEscaping = noEscaping;
        this.nsContext = nsContext;
    }

    public String getText() {
        return this.text;
    }

    public void instantiate(ProcessingEnv env, Node currentNode, ResultHandler result) throws XSLException {
        Trace.traceTemplate(XMLUtil.quote(this.text, 50));
        try {
            if (result instanceof Serializer) {
                ((Serializer)((Object)result)).noTextEscaping(this.noEscaping);
                result.characters(this.text);
                ((Serializer)((Object)result)).noTextEscaping(false);
            } else {
                result.characters(this.text);
            }
        }
        catch (IllegalNodeException e) {
            env.reportError(this.getNamespaceContext(), "pe7");
        }
        catch (ResultException e) {
            env.reportError(this.getNamespaceContext(), "pe8", e.getMessage());
        }
    }

    public Node getNamespaceContext() {
        return this.nsContext;
    }

    public void dump(PrintWriter out, int indent) {
        Util.indent(out, indent);
        out.println(XMLUtil.quote(this.text, 50));
    }
}

