/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathResetCache;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.VariableTemplate;
import com.novell.xsl.result.ResultHandler;
import org.w3c.dom.Node;

public class TopLevelVariableTemplate
extends VariableTemplate
implements XPathResetCache {
    private final int importance;
    private final int number;
    private int evalLevel = 0;
    private ProcessingEnv lazyEnv;
    private Expression replacement = null;

    public TopLevelVariableTemplate(VariableTemplate variable, int importance, int number, Node nsContext) {
        super(variable.getName(), variable.getSelect(), variable.getTemplates(), variable.isParam(), nsContext);
        this.importance = importance;
        this.number = number;
    }

    public void setLazyEnv(ProcessingEnv lazyEnv) {
        this.lazyEnv = lazyEnv;
        this.setCurrentValue(null);
    }

    public void replace(Expression replacement) {
        this.replacement = replacement;
    }

    public int getImportance() {
        return this.importance;
    }

    public int getNumber() {
        return this.number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instantiate(ProcessingEnv env, Node currentNode, ResultHandler result) throws XSLException {
        Trace.traceTemplate("top-level variable");
        try {
            if (++this.evalLevel > 1) {
                this.setCurrentValue(new StringValue());
                env.reportError(this.getNamespaceContext(), "pe13", this.getName().getQName());
            } else {
                super.instantiate(env, currentNode, result);
            }
        }
        finally {
            --this.evalLevel;
        }
    }

    public ExpressionValue evaluate(Node contextNode, ExpressionContext context) throws XPathEvaluationException {
        if (this.getCurrentValue() == null) {
            if (this.replacement == null) {
                try {
                    ProcessingEnv tempLazyEnv = new ProcessingEnv(this.lazyEnv);
                    this.instantiate(tempLazyEnv, tempLazyEnv.getContext().first(), tempLazyEnv.getTopLevelResultHandler());
                }
                catch (XSLException e) {
                    throw new XPathEvaluationException(e.getMessage());
                }
            } else {
                this.setCurrentValue(this.replacement.evaluate(contextNode, context));
            }
        }
        return this.getCurrentValue();
    }

    public void registerForReset(XPathResetRegistrar registrar) {
        super.registerForReset(registrar);
        registrar.registerResetCache(this);
    }

    public void resetCache() {
        this.setCurrentValue(null);
    }
}

