/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.result.Serializer;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class ValueOfTemplate
implements Template {
    private final Expression stringExpr;
    private final boolean noEscaping;
    private final Node nsContext;

    public ValueOfTemplate(Expression stringExpr, boolean noEscaping, Node nsContext) {
        this.stringExpr = stringExpr;
        this.noEscaping = noEscaping;
        this.nsContext = nsContext;
    }

    public Expression getExpr() {
        return this.stringExpr;
    }

    public void instantiate(ProcessingEnv env, Node currentNode, ResultHandler result) throws XSLException {
        Trace.traceTemplate("value-of");
        try {
            ExpressionValue value = env.getContext().evaluate(currentNode, this.stringExpr);
            Trace.traceSelect(this.stringExpr, value);
            String stringValue = value.getStringValue();
            if (stringValue.length() > 0) {
                if (result instanceof Serializer) {
                    ((Serializer)((Object)result)).noTextEscaping(this.noEscaping);
                    result.characters(value.getStringValue());
                    ((Serializer)((Object)result)).noTextEscaping(false);
                } else {
                    result.characters(value.getStringValue());
                }
            }
        }
        catch (IllegalNodeException e) {
            env.reportError(this.getNamespaceContext(), "pe7");
        }
        catch (ResultException e) {
            env.reportError(this.getNamespaceContext(), "pe8", e.getMessage());
        }
        catch (XPathEvaluationException e) {
            env.reportError(this.getNamespaceContext(), "pe2", e.getMessage());
        }
    }

    public Node getNamespaceContext() {
        return this.nsContext;
    }

    public void dump(PrintWriter out, int indent) {
        Util.indent(out, indent);
        out.println("value-of");
        Util.indent(out, indent);
        out.println("    expression");
        this.stringExpr.dump(out, indent + 1);
    }
}

