/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.ResultTreeFragment;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateCollection;
import com.novell.xsl.result.FragmentHandler;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class VariableTemplate
extends TemplateCollection
implements Expression {
    private ExpandedQName name;
    private Expression select;
    private boolean isParam;
    protected ExpressionValue currentValue = null;
    private int level = 0;
    private static Class returnType = null;

    public VariableTemplate(ExpandedQName name, Expression select, Template[] templates, Node nsContext) {
        this(name, select, templates, false, nsContext);
    }

    public VariableTemplate(ExpandedQName name, Expression select, Template[] templates, boolean isParam, Node nsContext) {
        super(templates, nsContext);
        this.name = name;
        this.select = select;
        this.isParam = isParam;
    }

    public ExpandedQName getName() {
        return this.name;
    }

    public Expression getSelect() {
        return this.select;
    }

    public boolean isParam() {
        return this.isParam;
    }

    public ExpressionValue getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(ExpressionValue value) {
        this.currentValue = value;
    }

    public void instantiate(ProcessingEnv env, Node currentNode, ResultHandler result) throws XSLException {
        Trace.traceTemplate(this.isParam() ? "param" : "variable");
        try {
            if (this.isParam) {
                this.currentValue = env.getParameter(this.name);
                if (this.currentValue != null) {
                    return;
                }
            }
            if (this.select != null) {
                this.currentValue = env.getContext().evaluate(currentNode, this.select);
                Trace.traceSelect(this.select, this.currentValue);
            } else if (this.getTemplates().length == 0) {
                this.currentValue = new StringValue();
            } else {
                FragmentHandler fragmentHandler = new FragmentHandler(env.getNodeFactory());
                this.instantiateTemplates(env, currentNode, fragmentHandler);
                this.currentValue = new ResultTreeFragment(fragmentHandler.getFragment());
            }
            if (!this.isParam) {
                env.setVariable(this);
            }
        }
        catch (XPathEvaluationException e) {
            env.reportError(this.getNamespaceContext(), "pe2", e.getMessage());
        }
    }

    public void dump(PrintWriter out, int indent) {
        Util.indent(out, indent);
        out.println(this.isParam() ? "param" : "variable");
        Util.indent(out, indent + 1);
        out.println("name: " + this.name);
        if (this.select != null) {
            out.println("select: " + this.select.toString());
        }
        super.dump(out, indent);
    }

    public ExpressionValue evaluate(Node contextNode, ExpressionContext context) throws XPathEvaluationException {
        return this.currentValue;
    }

    public boolean isConstant() {
        return false;
    }

    public Class getResultType() {
        if (this.isParam) {
            if (returnType == null) {
                returnType = XPathUtil.doGetClass("com.novell.xml.xpath.ExpressionValue");
            }
            return returnType;
        }
        if (this.select != null) {
            return this.select.getResultType();
        }
        if (this.getTemplates().length == 0) {
            return StringValue.getArgType();
        }
        return ResultTreeFragment.getArgType();
    }

    public void registerForReset(XPathResetRegistrar registrar) {
        if (++this.level == 1 && this.select != null) {
            this.select.registerForReset(registrar);
        }
        --this.level;
    }
}

