/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.result;

import com.novell.xml.dom.AttrImpl;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.NamespaceStack;
import com.novell.xml.xpath.XPathAttributeNode;
import com.novell.xsl.debug.Assert;
import com.novell.xsl.result.AttributeAfterChildException;
import com.novell.xsl.result.DOMResult;
import com.novell.xsl.result.IllegalNameException;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMResultHandler
implements ResultHandler,
DOMResult {
    private Document document;
    protected Node currentNode;
    private NamespaceStack currentNamespaces = new NamespaceStack();
    private boolean isLevel2DOM;

    public DOMResultHandler(Document document) {
        this.document = document;
        this.isLevel2DOM = document.getImplementation().hasFeature("XML", "2.0");
    }

    public Document getDocument() {
        return this.document;
    }

    public void startDocument() throws ResultException {
        Node child;
        while ((child = this.document.getFirstChild()) != null) {
            this.document.removeChild(child);
        }
        this.currentNode = this.document;
    }

    public void endDocument() throws ResultException {
        Assert.assertCondition(this.currentNode == this.document, "too few calls to endElement");
    }

    public void startElement(String name, String namespaceURI) throws IllegalNameException, IllegalNodeException, ResultException {
        Element newElement = null;
        try {
            if (this.isLevel2DOM) {
                if (namespaceURI.length() == 0 && name.indexOf(58) == -1) {
                    namespaceURI = null;
                }
                newElement = this.document.createElementNS(namespaceURI, name);
            } else {
                newElement = this.document.createElement(name);
            }
            this.currentNode = this.currentNode.appendChild(newElement);
            this.currentNamespaces.push();
        }
        catch (DOMException e) {
            if (e.code == 3) {
                throw new IllegalNodeException();
            }
            if (e.code == 5) {
                throw new IllegalNameException();
            }
            throw new ResultException(e);
        }
    }

    public void endElement(String name) throws ResultException {
        Assert.assertCondition(this.currentNode != this.document, "too many calls to endElement");
        this.currentNode = this.currentNode.getParentNode();
        this.currentNamespaces.pop();
    }

    public void attribute(String name, String value) throws AttributeAfterChildException, IllegalNameException, IllegalNodeException, ResultException {
        try {
            Element element = (Element)this.currentNode;
            if (element.hasChildNodes()) {
                throw new AttributeAfterChildException();
            }
            String namespaceURI = null;
            int index = name.indexOf(58);
            if (index != -1 && !name.startsWith("xmlns:")) {
                NamedNodeMap attrs = element.getAttributes();
                int len = attrs.getLength();
                ExpandedQName newName = new ExpandedQName(name, element);
                namespaceURI = newName.getNamespaceURI();
                if (len > 0) {
                    for (int i = 0; i < len; ++i) {
                        Attr attr;
                        Node nsAttr = attr = (Attr)attrs.item(i);
                        if (!(attr instanceof AttrImpl)) {
                            nsAttr = new XPathAttributeNode(attr, element);
                        }
                        if (!newName.equals(DOMUtil.getExpandedName(nsAttr))) continue;
                        element.removeAttributeNode(attr);
                        break;
                    }
                }
            }
            if (this.isLevel2DOM) {
                element.setAttributeNS(namespaceURI, name, value);
            } else {
                element.setAttribute(name, value);
            }
        }
        catch (ClassCastException e) {
            throw new IllegalNodeException();
        }
        catch (DOMException e) {
            if (e.code == 5) {
                throw new IllegalNameException();
            }
            throw new ResultException(e);
        }
    }

    public void characters(String data) throws IllegalNodeException, ResultException {
        try {
            Node prevSibling = this.currentNode.getLastChild();
            if (prevSibling != null && prevSibling.getNodeType() == 3) {
                ((Text)prevSibling).appendData(data);
            } else {
                this.currentNode.appendChild(this.document.createTextNode(data));
            }
        }
        catch (DOMException e) {
            if (e.code == 3) {
                throw new IllegalNodeException();
            }
            throw new ResultException(e);
        }
    }

    public void processingInstruction(String target, String value) throws IllegalNameException, IllegalNodeException, ResultException {
        try {
            this.currentNode.appendChild(this.document.createProcessingInstruction(target, value));
        }
        catch (DOMException e) {
            if (e.code == 3) {
                throw new IllegalNodeException();
            }
            if (e.code == 5) {
                throw new IllegalNameException();
            }
            throw new ResultException(e);
        }
    }

    public void comment(String value) throws IllegalNodeException, ResultException {
        try {
            this.currentNode.appendChild(this.document.createComment(value));
        }
        catch (DOMException e) {
            if (e.code == 3) {
                throw new IllegalNodeException();
            }
            throw new ResultException(e);
        }
    }

    public void namespace(String name, NamespaceName value) throws IllegalNodeException, ResultException {
        try {
            if (this.currentNamespaces.add(name, value)) {
                Element element = (Element)this.currentNode;
                String attrName = name.length() > 0 ? "xmlns:" + name : "xmlns";
                if (this.isLevel2DOM) {
                    element.setAttributeNS(NamespaceName.XMLNS_NAMESPACE.getString(), attrName, value.getString());
                } else {
                    element.setAttribute(attrName, value.getString());
                }
            }
        }
        catch (ClassCastException e) {
            throw new IllegalNodeException();
        }
        catch (DOMException e) {
            if (e.code == 5) {
                throw new IllegalNameException();
            }
            throw new ResultException(e);
        }
    }
}

