/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.result;

import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.XMLUtil;
import com.novell.xsl.result.AttributeAfterChildException;
import com.novell.xsl.result.HTMLSerializer;
import com.novell.xsl.result.IllegalNameException;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.result.Serializer;
import com.novell.xsl.result.SerializerOptions;
import com.novell.xsl.result.XMLSerializer;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultSerializer
implements ResultHandler,
Serializer {
    private ResultHandler impl = null;
    private OutputStream stream = null;
    private SerializerOptions options = null;
    private List bufferedStuff = null;
    private boolean noEscape = false;
    private boolean firstElement = false;
    private static final int USE_XML = 0;
    private static final int USE_HTML = 1;

    public DefaultSerializer() {
    }

    public DefaultSerializer(OutputStream stream) {
        this.stream = stream;
    }

    public void startDocument() throws ResultException {
        if (this.impl != null) {
            this.impl.startDocument();
        } else {
            this.initState();
        }
    }

    public void endDocument() throws ResultException {
        if (this.impl != null) {
            this.impl.endDocument();
        } else {
            this.startForReal();
        }
    }

    public void startElement(String name, String namespaceURI) throws IllegalNameException, IllegalNodeException, ResultException {
        if (this.impl != null) {
            this.impl.startElement(name, namespaceURI);
        } else {
            if (!XMLUtil.isQName(name)) {
                throw new IllegalNameException();
            }
            this.bufferNode(name, namespaceURI, 1);
        }
    }

    public void endElement(String name) throws ResultException {
        if (this.impl != null) {
            this.impl.endElement(name);
        } else {
            this.startForReal();
            this.impl.endElement(name);
        }
    }

    public void attribute(String name, String value) throws AttributeAfterChildException, IllegalNameException, IllegalNodeException, ResultException {
        if (this.impl != null) {
            this.impl.attribute(name, value);
        } else {
            if (!this.firstElement) {
                throw new IllegalNodeException();
            }
            if (!XMLUtil.isQName(name)) {
                throw new IllegalNameException();
            }
            this.bufferNode(name, value, 2);
        }
    }

    public void characters(String data) throws IllegalNodeException, ResultException {
        if (this.impl != null) {
            this.impl.characters(data);
        } else {
            this.bufferNode(null, data, 3);
        }
    }

    public void processingInstruction(String target, String value) throws IllegalNameException, IllegalNodeException, ResultException {
        if (this.impl != null) {
            this.impl.processingInstruction(target, value);
        } else {
            if (!XMLUtil.isPITarget(target)) {
                throw new IllegalNameException();
            }
            this.bufferNode(target, value, 7);
        }
    }

    public void comment(String value) throws IllegalNodeException, ResultException {
        if (this.impl != null) {
            this.impl.comment(value);
        } else {
            this.bufferNode(null, value, 8);
        }
    }

    public void namespace(String name, NamespaceName value) throws IllegalNodeException, ResultException {
        if (this.impl != null) {
            this.impl.namespace(name, value);
        } else {
            if (!this.firstElement) {
                throw new IllegalNodeException();
            }
            this.bufferNode(name, value.getString(), -1);
        }
    }

    public SerializerOptions getOptions() {
        if (this.impl != null) {
            return ((Serializer)((Object)this.impl)).getOptions();
        }
        return this.options;
    }

    public void setOptions(SerializerOptions options) {
        if (this.impl != null) {
            ((Serializer)((Object)this.impl)).setOptions(options);
            this.options = options;
        } else {
            if (options == null) {
                throw new IllegalArgumentException("DefaultSerializer.setOptions: null options");
            }
            this.options = options;
        }
    }

    public OutputStream getStream() {
        if (this.impl != null) {
            return ((Serializer)((Object)this.impl)).getStream();
        }
        return this.stream;
    }

    public void setStream(OutputStream stream) {
        if (this.impl != null) {
            ((Serializer)((Object)this.impl)).setStream(stream);
        } else {
            this.stream = stream;
        }
    }

    public void noTextEscaping(boolean noEscape) {
        if (this.impl != null) {
            ((Serializer)((Object)this.impl)).noTextEscaping(noEscape);
        } else {
            this.noEscape = noEscape;
        }
    }

    private void bufferNode(String name, String value, int nodeType) throws ResultException {
        if (this.bufferedStuff == null) {
            this.bufferedStuff = new ArrayList(8);
        }
        this.bufferedStuff.add(new NodeBuffer(name, value, nodeType, this.noEscape));
        if (this.firstElement && nodeType != 2 && nodeType != -1 || nodeType == 3 && !XMLUtil.isXMLWhitespace(value)) {
            this.startForReal();
            return;
        }
        if (nodeType == 1) {
            this.firstElement = true;
        }
    }

    private void startForReal() throws ResultException {
        boolean use;
        Iterator it;
        if (this.bufferedStuff != null) {
            it = this.bufferedStuff.iterator();
            boolean allWhite = true;
            boolean htmlElement = false;
            while (it.hasNext()) {
                NodeBuffer node = (NodeBuffer)it.next();
                if (node.getType() == 3) {
                    if (XMLUtil.isXMLWhitespace(node.getValue())) continue;
                    allWhite = false;
                    break;
                }
                if (node.getType() != 1) continue;
                String nodeName = node.getName();
                if (!nodeName.equalsIgnoreCase("html")) break;
                while (it.hasNext() && ((node = (NodeBuffer)it.next()).getType() != -1 || !node.getName().equals(""))) {
                }
                if (it.hasNext()) break;
                htmlElement = true;
                break;
            }
            use = allWhite && htmlElement;
        } else {
            use = false;
        }
        this.impl = use ? new HTMLSerializer(this.stream) : new XMLSerializer(this.stream);
        if (this.options != null) {
            ((Serializer)((Object)this.impl)).setOptions(this.options);
        }
        this.impl.startDocument();
        if (this.bufferedStuff != null) {
            it = this.bufferedStuff.iterator();
            while (it.hasNext()) {
                NodeBuffer node = (NodeBuffer)it.next();
                int type = node.getType();
                if (type == 3) {
                    if (node.getNoEscape()) {
                        ((Serializer)((Object)this.impl)).noTextEscaping(true);
                        this.impl.characters(node.getValue());
                        ((Serializer)((Object)this.impl)).noTextEscaping(false);
                        continue;
                    }
                    this.impl.characters(node.getValue());
                    continue;
                }
                if (type == 8) {
                    this.impl.comment(node.getValue());
                    continue;
                }
                if (type == 7) {
                    this.impl.processingInstruction(node.getName(), node.getValue());
                    continue;
                }
                if (type == 1) {
                    this.impl.startElement(node.getName(), node.getValue());
                    continue;
                }
                if (type == 2) {
                    this.impl.attribute(node.getName(), node.getValue());
                    continue;
                }
                if (type != -1) continue;
                this.impl.namespace(node.getName(), new NamespaceName(node.getValue()));
            }
            this.bufferedStuff.clear();
            this.bufferedStuff = null;
        }
    }

    private void initState() {
        if (this.bufferedStuff != null) {
            this.bufferedStuff.clear();
        }
        this.impl = null;
        this.noEscape = false;
        this.firstElement = false;
    }

    static class NodeBuffer {
        private final int type;
        private final String name;
        private final String value;
        private final boolean noEscape;

        public NodeBuffer(String name, String value, int type, boolean noEscape) {
            this.name = name;
            this.value = value;
            this.type = type;
            this.noEscape = noEscape;
        }

        public int getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean getNoEscape() {
            return this.noEscape;
        }
    }
}

