/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.result;

import com.novell.io.CharEncoder;
import com.novell.io.CharEncodingException;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.XMLUtil;
import com.novell.xsl.result.IllegalNameException;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.XMLSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class HTMLSerializer
extends XMLSerializer {
    private CharEncoder utf8Encoder = null;
    private boolean htmlNoEscape = false;
    private static Collection htmlElements;
    private static Collection emptyElements;
    private static Collection uriAttributes;
    private static Collection minimizedAttributes;
    private static Map charEntities;
    private static boolean setup;
    private static Object gate;

    public HTMLSerializer() {
        HTMLSerializer.staticSetup();
    }

    public HTMLSerializer(OutputStream stream) {
        super(stream);
        HTMLSerializer.staticSetup();
    }

    public void startDocument() throws ResultException {
        this.initWriter();
        this.initState();
        this.forceDTD = true;
    }

    public void startElement(String name, String namespaceURI) throws IllegalNameException, IllegalNodeException, ResultException {
        super.startElement(name, namespaceURI);
        if (name.equalsIgnoreCase("script") || name.equalsIgnoreCase("style")) {
            this.htmlNoEscape = true;
        }
    }

    public void characters(String data) throws IllegalNodeException, ResultException {
        try {
            this.children = true;
            this.closeStartTag();
            if (this.noEscape || this.htmlNoEscape) {
                this.writer.write(data);
            } else if (this.cdataOutput) {
                XMLUtil.encodeAsCData(this.writer, data);
            } else {
                this.encodeHTML(data, null, false);
            }
            this.nodeType = 3;
        }
        catch (IOException e) {
            throw new ResultException(e);
        }
    }

    public void processingInstruction(String target, String value) throws IllegalNameException, IllegalNodeException, ResultException {
        try {
            if (!XMLUtil.isPITarget(target)) {
                throw new IllegalNameException();
            }
            this.children = true;
            this.closeStartTag();
            this.injectWhitespace(7, this.nodeType);
            this.writer.write("<?");
            this.writer.write(target);
            if (value != null && value.length() > 0) {
                this.writer.write(32);
                this.writer.write(value);
            }
            this.writer.write(">");
            this.nodeType = 7;
        }
        catch (IOException e) {
            throw new ResultException(e);
        }
    }

    protected void writeDTD(String name) throws IOException {
        String doctypePublic = this.options.getDoctypePublic();
        String doctypeSystem = this.options.getDoctypeSystem();
        if (!(doctypePublic != null && doctypePublic.length() != 0 || doctypeSystem != null && doctypeSystem.length() != 0)) {
            return;
        }
        this.writer.write("<!DOCTYPE HTML");
        if (doctypePublic != null && doctypePublic.length() > 0) {
            this.writer.write(" PUBLIC ");
            int quote = doctypePublic.indexOf(34) != -1 ? 39 : 34;
            this.writer.write(quote);
            this.writer.write(doctypePublic);
            this.writer.write(quote);
            this.writer.write(32);
            if (doctypeSystem != null && doctypeSystem.length() > 0) {
                quote = doctypeSystem.indexOf(34) != -1 ? 39 : 34;
                this.writer.write(quote);
                this.writer.write(doctypeSystem);
                this.writer.write(quote);
            } else {
                this.writer.write("\"http://www.w3.org/TR/REC-html40/strict.dtd\"");
            }
        } else if (doctypeSystem != null && doctypePublic.length() > 0) {
            this.writer.write(" SYSTEM ");
            int quote = doctypeSystem.indexOf(34) != -1 ? 39 : 34;
            this.writer.write(quote);
            this.writer.write(doctypeSystem);
            this.writer.write(quote);
        } else {
            this.writer.write(" PUBLIC \"-//W3C//DTD HTML 4.0//EN\" \"http://www.w3.org/TR/REC-html40/strict.dtd\"");
        }
        this.writer.write(">");
    }

    protected void writeMeta() throws IOException {
        this.writer.write("<META http-equiv=\"Content-Type\" content=\"");
        if (this.options.getMediaType() != null && this.options.getMediaType().length() != 0) {
            this.writer.write(this.options.getMediaType());
        } else {
            this.writer.write("text/html");
        }
        this.writer.write("; charset=");
        this.writer.write(this.actualEncoding);
        this.writer.write("\">");
    }

    protected void closeStartTag() throws IOException, ResultException {
        if (this.startTagOpen) {
            this.startTagOpen = false;
            ExpandedQName expandedName = this.getExpandedName(this.elementName, false);
            boolean recognizeHTML = expandedName.getNamespaceName().isEmpty() && htmlElements.contains(expandedName.getLocalPart());
            if (recognizeHTML) {
                this.outputHTMLAttributes();
            } else {
                for (int i = 0; i < this.attributeNames.size(); ++i) {
                    this.outputXMLAttribute((ExpandedQName)this.attributeNames.get(i), (String)this.attributeValues.get(i));
                }
            }
            if (this.children || recognizeHTML && emptyElements.contains(this.elementName)) {
                this.writer.write(62);
            } else if (recognizeHTML) {
                this.writer.write("></");
                this.writer.write(this.elementName);
                this.writer.write(62);
            } else {
                this.writer.write("/>");
            }
            if (recognizeHTML && this.elementName.equalsIgnoreCase("HEAD")) {
                this.injectWhitespace(1, 1);
                this.writeMeta();
            }
        }
    }

    protected void outputHTMLAttributes() throws IOException {
        for (int i = 0; i < this.attributeNames.size(); ++i) {
            ExpandedQName name = (ExpandedQName)this.attributeNames.get(i);
            if (!name.getNamespaceName().isEmpty()) {
                this.outputXMLAttribute(name, (String)this.attributeValues.get(i));
                continue;
            }
            this.writer.write(32);
            String localPart = name.getLocalPart();
            this.writer.write(localPart);
            if (minimizedAttributes.contains(localPart)) continue;
            this.writer.write(61);
            if (!uriAttributes.contains(localPart)) {
                this.writeHTMLattribute((String)this.attributeValues.get(i));
                continue;
            }
            this.writeURIattribute((String)this.attributeValues.get(i));
        }
    }

    protected void writeHTMLattribute(String value) throws IOException {
        boolean hasNewLine;
        boolean hasDouble = value.indexOf(34) != -1;
        boolean hasSingle = value.indexOf(39) != -1;
        boolean bl = hasNewLine = value.indexOf(10) != -1;
        if (hasDouble && hasSingle || hasNewLine) {
            this.writer.write(34);
            this.encodeHTML(value, "\"\n", true);
            this.writer.write(34);
        } else if (hasDouble) {
            this.writer.write(39);
            this.encodeHTML(value, "'\n", true);
            this.writer.write(39);
        } else {
            this.writer.write(34);
            this.encodeHTML(value, "\n", true);
            this.writer.write(34);
        }
    }

    protected void encodeHTML(String value, String specials, boolean isAttribute) throws IOException {
        if (value.length() == 0) {
            return;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '&' && (!isAttribute || i + 1 < value.length() && value.charAt(i + 1) != '{')) {
                this.writer.write("&amp;");
                continue;
            }
            if (c == '<' && !isAttribute) {
                this.writer.write("&lt;");
                continue;
            }
            if (specials != null && specials.indexOf(c) != -1) {
                this.writer.write("&#x");
                this.writer.write(Integer.toHexString(c));
                this.writer.write(59);
                continue;
            }
            if ('\u0001' <= c && c <= '\u007f') {
                this.writer.write(c);
                continue;
            }
            if (c >= '\ud800' && c <= '\udc00') {
                char trail = value.charAt(++i);
                int char4 = (c - 55296 << 10) + (trail - 56320) + 65536;
                this.writer.write("&#x");
                this.writer.write(Integer.toHexString(char4));
                this.writer.write(59);
                continue;
            }
            String entity = (String)charEntities.get(new Character(c));
            if (entity != null) {
                this.writer.write(38);
                this.writer.write(entity);
                this.writer.write(59);
                continue;
            }
            try {
                this.writer.write(c);
                continue;
            }
            catch (CharEncodingException e) {
                this.writer.write("&#x");
                int charValue = e.getValue();
                this.writer.write(Integer.toHexString(charValue));
                this.writer.write(59);
                i += charValue < 65535 ? 1 : 2;
            }
        }
    }

    protected void writeURIattribute(String value) throws IOException {
        byte[] buffer = new byte[6];
        this.writer.write(34);
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c <= '\u007f' && c >= '!' && c != '\"') {
                this.writer.write(c);
                continue;
            }
            if (this.utf8Encoder == null) {
                this.utf8Encoder = CharEncoder.getEncoder("UTF-8");
            }
            int bytes = this.utf8Encoder.encodeChar(c, buffer, 0);
            for (int j = 0; j < bytes; ++j) {
                this.writer.write(37);
                this.writer.write(Integer.toHexString(buffer[j] & 0xFF));
            }
        }
        this.writer.write(34);
    }

    protected void initState() {
        super.initState();
        this.htmlNoEscape = false;
        if (!this.getOptions().wasIndentSet()) {
            this.getOptions().setIndent(true);
        }
    }

    protected void doIndent(int level) throws IOException {
    }

    protected void pushState() {
        super.pushState();
        this.stateStack.push(this.htmlNoEscape ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void popState() {
        this.htmlNoEscape = (Boolean)this.stateStack.pop();
        super.popState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void staticSetup() {
        Object object = gate;
        synchronized (object) {
            if (setup) {
                return;
            }
            NoCaseComparator comp = new NoCaseComparator();
            htmlElements = new TreeSet(comp);
            htmlElements.add("a");
            htmlElements.add("abbr");
            htmlElements.add("acronym");
            htmlElements.add("address");
            htmlElements.add("applet");
            htmlElements.add("area");
            htmlElements.add("b");
            htmlElements.add("base");
            htmlElements.add("basefont");
            htmlElements.add("bdo");
            htmlElements.add("big");
            htmlElements.add("blockquote");
            htmlElements.add("body");
            htmlElements.add("br");
            htmlElements.add("button");
            htmlElements.add("caption");
            htmlElements.add("center");
            htmlElements.add("cite");
            htmlElements.add("code");
            htmlElements.add("col");
            htmlElements.add("colgroup");
            htmlElements.add("dd");
            htmlElements.add("del");
            htmlElements.add("dfn");
            htmlElements.add("dir");
            htmlElements.add("div");
            htmlElements.add("dl");
            htmlElements.add("dt");
            htmlElements.add("em");
            htmlElements.add("fieldset");
            htmlElements.add("font");
            htmlElements.add("form");
            htmlElements.add("frame");
            htmlElements.add("frameset");
            htmlElements.add("h1");
            htmlElements.add("h2");
            htmlElements.add("h3");
            htmlElements.add("h4");
            htmlElements.add("h5");
            htmlElements.add("h6");
            htmlElements.add("head");
            htmlElements.add("hr");
            htmlElements.add("html");
            htmlElements.add("i");
            htmlElements.add("iframe");
            htmlElements.add("img");
            htmlElements.add("input");
            htmlElements.add("ins");
            htmlElements.add("isindex");
            htmlElements.add("kbd");
            htmlElements.add("label");
            htmlElements.add("legend");
            htmlElements.add("li");
            htmlElements.add("link");
            htmlElements.add("map");
            htmlElements.add("menu");
            htmlElements.add("meta");
            htmlElements.add("noframes");
            htmlElements.add("noscript");
            htmlElements.add("object");
            htmlElements.add("ol");
            htmlElements.add("optgroup");
            htmlElements.add("option");
            htmlElements.add("p");
            htmlElements.add("param");
            htmlElements.add("pre");
            htmlElements.add("q");
            htmlElements.add("s");
            htmlElements.add("samp");
            htmlElements.add("script");
            htmlElements.add("select");
            htmlElements.add("small");
            htmlElements.add("span");
            htmlElements.add("strike");
            htmlElements.add("strong");
            htmlElements.add("style");
            htmlElements.add("sub");
            htmlElements.add("sup");
            htmlElements.add("table");
            htmlElements.add("tbody");
            htmlElements.add("td");
            htmlElements.add("textarea");
            htmlElements.add("tfoot");
            htmlElements.add("th");
            htmlElements.add("thead");
            htmlElements.add("title");
            htmlElements.add("tr");
            htmlElements.add("tt");
            htmlElements.add("u");
            htmlElements.add("ul");
            htmlElements.add("var");
            emptyElements = new TreeSet(comp);
            emptyElements.add("area");
            emptyElements.add("base");
            emptyElements.add("basefont");
            emptyElements.add("br");
            emptyElements.add("col");
            emptyElements.add("frame");
            emptyElements.add("hr");
            emptyElements.add("img");
            emptyElements.add("input");
            emptyElements.add("isindex");
            emptyElements.add("link");
            emptyElements.add("meta");
            emptyElements.add("param");
            uriAttributes = new TreeSet(comp);
            uriAttributes.add("action");
            uriAttributes.add("archive");
            uriAttributes.add("cite");
            uriAttributes.add("classid");
            uriAttributes.add("codebase");
            uriAttributes.add("data");
            uriAttributes.add("href");
            uriAttributes.add("longdesc");
            uriAttributes.add("profile");
            uriAttributes.add("src");
            uriAttributes.add("usemap");
            minimizedAttributes = new TreeSet(comp);
            minimizedAttributes.add("checked");
            minimizedAttributes.add("declare");
            minimizedAttributes.add("defer");
            minimizedAttributes.add("disabled");
            minimizedAttributes.add("ismap");
            minimizedAttributes.add("multiple");
            minimizedAttributes.add("nohref");
            minimizedAttributes.add("readonly");
            minimizedAttributes.add("selected");
            charEntities = new TreeMap(new CharComparator());
            charEntities.put(new Character('\u00a0'), "nbsp");
            charEntities.put(new Character('\u00a1'), "iexcl");
            charEntities.put(new Character('\u00a2'), "cent");
            charEntities.put(new Character('\u00a3'), "pound");
            charEntities.put(new Character('\u00a4'), "curren");
            charEntities.put(new Character('\u00a5'), "yen");
            charEntities.put(new Character('\u00a6'), "brvbar");
            charEntities.put(new Character('\u00a7'), "sect");
            charEntities.put(new Character('\u00a8'), "uml");
            charEntities.put(new Character('\u00a9'), "copy");
            charEntities.put(new Character('\u00aa'), "ordf");
            charEntities.put(new Character('\u00ab'), "laquo");
            charEntities.put(new Character('\u00ac'), "not");
            charEntities.put(new Character('\u00ad'), "shy");
            charEntities.put(new Character('\u00ae'), "reg");
            charEntities.put(new Character('\u00af'), "macr");
            charEntities.put(new Character('\u00b0'), "deg");
            charEntities.put(new Character('\u00b1'), "plusmn");
            charEntities.put(new Character('\u00b2'), "sup2");
            charEntities.put(new Character('\u00b3'), "sup3");
            charEntities.put(new Character('\u00b4'), "acute");
            charEntities.put(new Character('\u00b5'), "micro");
            charEntities.put(new Character('\u00b6'), "para");
            charEntities.put(new Character('\u00b7'), "middot");
            charEntities.put(new Character('\u00b8'), "cedil");
            charEntities.put(new Character('\u00b9'), "sup1");
            charEntities.put(new Character('\u00ba'), "ordm");
            charEntities.put(new Character('\u00bb'), "raquo");
            charEntities.put(new Character('\u00bc'), "frac14");
            charEntities.put(new Character('\u00bd'), "frac12");
            charEntities.put(new Character('\u00be'), "frac34");
            charEntities.put(new Character('\u00bf'), "iquest");
            charEntities.put(new Character('\u00c0'), "Agrave");
            charEntities.put(new Character('\u00c1'), "Aacute");
            charEntities.put(new Character('\u00c2'), "Acirc");
            charEntities.put(new Character('\u00c3'), "Atilde");
            charEntities.put(new Character('\u00c4'), "Auml");
            charEntities.put(new Character('\u00c5'), "Aring");
            charEntities.put(new Character('\u00c6'), "AElig");
            charEntities.put(new Character('\u00c7'), "Ccedil");
            charEntities.put(new Character('\u00c8'), "Egrave");
            charEntities.put(new Character('\u00c9'), "Eacute");
            charEntities.put(new Character('\u00ca'), "Ecirc");
            charEntities.put(new Character('\u00cb'), "Euml");
            charEntities.put(new Character('\u00cc'), "Igrave");
            charEntities.put(new Character('\u00cd'), "Iacute");
            charEntities.put(new Character('\u00ce'), "Icirc");
            charEntities.put(new Character('\u00cf'), "Iuml");
            charEntities.put(new Character('\u00d0'), "ETH");
            charEntities.put(new Character('\u00d1'), "Ntilde");
            charEntities.put(new Character('\u00d2'), "Ograve");
            charEntities.put(new Character('\u00d3'), "Oacute");
            charEntities.put(new Character('\u00d4'), "Ocirc");
            charEntities.put(new Character('\u00d5'), "Otilde");
            charEntities.put(new Character('\u00d6'), "Ouml");
            charEntities.put(new Character('\u00d7'), "times");
            charEntities.put(new Character('\u00d8'), "Oslash");
            charEntities.put(new Character('\u00d9'), "Ugrave");
            charEntities.put(new Character('\u00da'), "Uacute");
            charEntities.put(new Character('\u00db'), "Ucirc");
            charEntities.put(new Character('\u00dc'), "Uuml");
            charEntities.put(new Character('\u00dd'), "Yacute");
            charEntities.put(new Character('\u00de'), "THORN");
            charEntities.put(new Character('\u00df'), "szlig");
            charEntities.put(new Character('\u00e0'), "agrave");
            charEntities.put(new Character('\u00e1'), "aacute");
            charEntities.put(new Character('\u00e2'), "acirc");
            charEntities.put(new Character('\u00e3'), "atilde");
            charEntities.put(new Character('\u00e4'), "auml");
            charEntities.put(new Character('\u00e5'), "aring");
            charEntities.put(new Character('\u00e6'), "aelig");
            charEntities.put(new Character('\u00e7'), "ccedil");
            charEntities.put(new Character('\u00e8'), "egrave");
            charEntities.put(new Character('\u00e9'), "eacute");
            charEntities.put(new Character('\u00ea'), "ecirc");
            charEntities.put(new Character('\u00eb'), "euml");
            charEntities.put(new Character('\u00ec'), "igrave");
            charEntities.put(new Character('\u00ed'), "iacute");
            charEntities.put(new Character('\u00ee'), "icirc");
            charEntities.put(new Character('\u00ef'), "iuml");
            charEntities.put(new Character('\u00f0'), "eth");
            charEntities.put(new Character('\u00f1'), "ntilde");
            charEntities.put(new Character('\u00f2'), "ograve");
            charEntities.put(new Character('\u00f3'), "oacute");
            charEntities.put(new Character('\u00f4'), "ocirc");
            charEntities.put(new Character('\u00f5'), "otilde");
            charEntities.put(new Character('\u00f6'), "ouml");
            charEntities.put(new Character('\u00f7'), "divide");
            charEntities.put(new Character('\u00f8'), "oslash");
            charEntities.put(new Character('\u00f9'), "ugrave");
            charEntities.put(new Character('\u00fa'), "uacute");
            charEntities.put(new Character('\u00fb'), "ucirc");
            charEntities.put(new Character('\u00fc'), "uuml");
            charEntities.put(new Character('\u00fd'), "yacute");
            charEntities.put(new Character('\u00fe'), "thorn");
            charEntities.put(new Character('\u00ff'), "yuml");
            charEntities.put(new Character('\u0192'), "fnof");
            charEntities.put(new Character('\u0391'), "Alpha");
            charEntities.put(new Character('\u0392'), "Beta");
            charEntities.put(new Character('\u0393'), "Gamma");
            charEntities.put(new Character('\u0394'), "Delta");
            charEntities.put(new Character('\u0395'), "Epsilon");
            charEntities.put(new Character('\u0396'), "Zeta");
            charEntities.put(new Character('\u0397'), "Eta");
            charEntities.put(new Character('\u0398'), "Theta");
            charEntities.put(new Character('\u0399'), "Iota");
            charEntities.put(new Character('\u039a'), "Kappa");
            charEntities.put(new Character('\u039b'), "Lambda");
            charEntities.put(new Character('\u039c'), "Mu");
            charEntities.put(new Character('\u039d'), "Nu");
            charEntities.put(new Character('\u039e'), "Xi");
            charEntities.put(new Character('\u039f'), "Omicron");
            charEntities.put(new Character('\u03a0'), "Pi");
            charEntities.put(new Character('\u03a1'), "Rho");
            charEntities.put(new Character('\u03a3'), "Sigma");
            charEntities.put(new Character('\u03a4'), "Tau");
            charEntities.put(new Character('\u03a5'), "Upsilon");
            charEntities.put(new Character('\u03a6'), "Phi");
            charEntities.put(new Character('\u03a7'), "Chi");
            charEntities.put(new Character('\u03a8'), "Psi");
            charEntities.put(new Character('\u03a9'), "Omega");
            charEntities.put(new Character('\u03b1'), "alpha");
            charEntities.put(new Character('\u03b2'), "beta");
            charEntities.put(new Character('\u03b3'), "gamma");
            charEntities.put(new Character('\u03b4'), "delta");
            charEntities.put(new Character('\u03b5'), "epsilon");
            charEntities.put(new Character('\u03b6'), "zeta");
            charEntities.put(new Character('\u03b7'), "eta");
            charEntities.put(new Character('\u03b8'), "theta");
            charEntities.put(new Character('\u03b9'), "iota");
            charEntities.put(new Character('\u03ba'), "kappa");
            charEntities.put(new Character('\u03bb'), "lambda");
            charEntities.put(new Character('\u03bc'), "mu");
            charEntities.put(new Character('\u03bd'), "nu");
            charEntities.put(new Character('\u03be'), "xi");
            charEntities.put(new Character('\u03bf'), "omicron");
            charEntities.put(new Character('\u03c0'), "pi");
            charEntities.put(new Character('\u03c1'), "rho");
            charEntities.put(new Character('\u03c2'), "sigmaf");
            charEntities.put(new Character('\u03c3'), "sigma");
            charEntities.put(new Character('\u03c4'), "tau");
            charEntities.put(new Character('\u03c5'), "upsilon");
            charEntities.put(new Character('\u03c6'), "phi");
            charEntities.put(new Character('\u03c7'), "chi");
            charEntities.put(new Character('\u03c8'), "psi");
            charEntities.put(new Character('\u03c9'), "omega");
            charEntities.put(new Character('\u03d1'), "thetasym");
            charEntities.put(new Character('\u03d2'), "upsih");
            charEntities.put(new Character('\u03d6'), "piv");
            charEntities.put(new Character('\u2022'), "bull");
            charEntities.put(new Character('\u2026'), "hellip");
            charEntities.put(new Character('\u2032'), "prime");
            charEntities.put(new Character('\u2033'), "Prime");
            charEntities.put(new Character('\u203e'), "oline");
            charEntities.put(new Character('\u2044'), "frasl");
            charEntities.put(new Character('\u2118'), "weierp");
            charEntities.put(new Character('\u2111'), "image");
            charEntities.put(new Character('\u211c'), "real");
            charEntities.put(new Character('\u2122'), "trade");
            charEntities.put(new Character('\u2135'), "alefsym");
            charEntities.put(new Character('\u2190'), "larr");
            charEntities.put(new Character('\u2191'), "uarr");
            charEntities.put(new Character('\u2192'), "rarr");
            charEntities.put(new Character('\u2193'), "darr");
            charEntities.put(new Character('\u2194'), "harr");
            charEntities.put(new Character('\u21b5'), "crarr");
            charEntities.put(new Character('\u21d0'), "lArr");
            charEntities.put(new Character('\u21d1'), "uArr");
            charEntities.put(new Character('\u21d2'), "rArr");
            charEntities.put(new Character('\u21d3'), "dArr");
            charEntities.put(new Character('\u21d4'), "hArr");
            charEntities.put(new Character('\u2200'), "forall");
            charEntities.put(new Character('\u2202'), "part");
            charEntities.put(new Character('\u2203'), "exist");
            charEntities.put(new Character('\u2205'), "empty");
            charEntities.put(new Character('\u2207'), "nabla");
            charEntities.put(new Character('\u2208'), "isin");
            charEntities.put(new Character('\u2209'), "notin");
            charEntities.put(new Character('\u220b'), "ni");
            charEntities.put(new Character('\u220f'), "prod");
            charEntities.put(new Character('\u2211'), "sum");
            charEntities.put(new Character('\u2212'), "minus");
            charEntities.put(new Character('\u2217'), "lowast");
            charEntities.put(new Character('\u221a'), "radic");
            charEntities.put(new Character('\u221d'), "prop");
            charEntities.put(new Character('\u221e'), "infin");
            charEntities.put(new Character('\u2220'), "ang");
            charEntities.put(new Character('\u2227'), "and");
            charEntities.put(new Character('\u2228'), "or");
            charEntities.put(new Character('\u2229'), "cap");
            charEntities.put(new Character('\u222a'), "cup");
            charEntities.put(new Character('\u222b'), "int");
            charEntities.put(new Character('\u2234'), "there4");
            charEntities.put(new Character('\u223c'), "sim");
            charEntities.put(new Character('\u2245'), "cong");
            charEntities.put(new Character('\u2248'), "asymp");
            charEntities.put(new Character('\u2260'), "ne");
            charEntities.put(new Character('\u2261'), "equiv");
            charEntities.put(new Character('\u2264'), "le");
            charEntities.put(new Character('\u2265'), "ge");
            charEntities.put(new Character('\u2282'), "sub");
            charEntities.put(new Character('\u2283'), "sup");
            charEntities.put(new Character('\u2284'), "nsub");
            charEntities.put(new Character('\u2286'), "sube");
            charEntities.put(new Character('\u2287'), "supe");
            charEntities.put(new Character('\u2295'), "oplus");
            charEntities.put(new Character('\u2297'), "otimes");
            charEntities.put(new Character('\u22a5'), "perp");
            charEntities.put(new Character('\u22c5'), "sdot");
            charEntities.put(new Character('\u2308'), "lceil");
            charEntities.put(new Character('\u2309'), "rceil");
            charEntities.put(new Character('\u230a'), "lfloor");
            charEntities.put(new Character('\u230b'), "rfloor");
            charEntities.put(new Character('\u2329'), "lang");
            charEntities.put(new Character('\u232a'), "rang");
            charEntities.put(new Character('\u25ca'), "loz");
            charEntities.put(new Character('\u2660'), "spades");
            charEntities.put(new Character('\u2663'), "clubs");
            charEntities.put(new Character('\u2665'), "hearts");
            charEntities.put(new Character('\u2666'), "diams");
            setup = true;
        }
    }

    static {
        setup = false;
        gate = new Object();
    }

    static class CharComparator
    implements Comparator {
        CharComparator() {
        }

        public boolean equals(Object lhs, Object rhs) {
            return lhs.equals(rhs);
        }

        public int compare(Object lhs, Object rhs) {
            return ((Character)lhs).charValue() - ((Character)rhs).charValue();
        }
    }

    static class NoCaseComparator
    implements Comparator {
        NoCaseComparator() {
        }

        public boolean equals(Object lhs, Object rhs) {
            return lhs == rhs;
        }

        public int compare(Object lhs, Object rhs) {
            String lhsString = (String)lhs;
            String rhsString = (String)rhs;
            int len1 = lhsString.length();
            int len2 = rhsString.length();
            int max = Math.min(len1, len2);
            for (int i = 0; i < max; ++i) {
                int dif = Character.toLowerCase(lhsString.charAt(i)) - Character.toLowerCase(rhsString.charAt(i));
                if (dif == 0) continue;
                return dif;
            }
            return len1 - len2;
        }
    }
}

