/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.result;

import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.parser.SAXParserImpl;
import com.novell.xml.parser.XMLParser;
import com.novell.xml.parser.XMLParserFactory;
import com.novell.xml.sax.DocumentCommentHandler;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.NamespaceStack;
import com.novell.xml.util.XMLUtil;
import com.novell.xsl.DefaultErrorHandler;
import com.novell.xsl.DefaultMessageHandler;
import com.novell.xsl.SAXtoDOMStrip;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.XSLException;
import com.novell.xsl.result.AttributeAfterChildException;
import com.novell.xsl.result.IllegalNameException;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import org.w3c.dom.Document;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class SAXResultHandler
implements ResultHandler,
Parser {
    protected DocumentHandler documentHandler = null;
    protected ErrorHandler errorHandler = null;
    protected boolean doPIComments = false;
    protected String elementName;
    protected boolean startTagOpen = false;
    protected List attributeNames = new ArrayList(16);
    protected List attributeValues = new ArrayList(16);
    protected NamespaceStack currentNamespaces = new NamespaceStack();
    protected Stack stateStack = new Stack();
    protected AttributeListImpl attrList = new AttributeListImpl();
    protected Stylesheet stylesheet;
    protected Parser parser = null;
    protected Document sourceDocument = null;

    public SAXResultHandler(String stylesheetURL) throws IOException, XSLException {
        XMLParser xmlParser = XMLParserFactory.newParser();
        Document xslDoc = xmlParser.parse(stylesheetURL);
        if (xmlParser.anyErrors()) {
            throw new XSLException(xmlParser.getErrorMsgString());
        }
        DefaultErrorHandler errorHandler = new DefaultErrorHandler();
        DefaultMessageHandler messageHandler = new DefaultMessageHandler();
        this.stylesheet = new Stylesheet();
        this.stylesheet.setErrorHandler(errorHandler);
        this.stylesheet.setMessageHandler(messageHandler);
        this.stylesheet.setBaseURI(stylesheetURL);
        this.stylesheet.load(xslDoc);
    }

    public SAXResultHandler(Parser sourceParser, Stylesheet stylesheet) {
        this.parser = sourceParser;
        this.stylesheet = stylesheet;
    }

    public SAXResultHandler(Document sourceDocument, Stylesheet stylesheet) {
        this.sourceDocument = sourceDocument;
        this.stylesheet = stylesheet;
    }

    public SAXResultHandler(Stylesheet stylesheet) {
        this.stylesheet = stylesheet;
    }

    public SAXResultHandler() {
        this.stylesheet = null;
    }

    public void setUsePIComment(boolean usePIComment) {
        this.doPIComments = usePIComment;
    }

    public void startDocument() throws ResultException {
        if (this.documentHandler != null) {
            try {
                this.documentHandler.startDocument();
            }
            catch (SAXException e) {
                throw new ResultException(e);
            }
        }
    }

    public void endDocument() throws ResultException {
        if (this.documentHandler != null) {
            try {
                this.documentHandler.endDocument();
            }
            catch (SAXException e) {
                throw new ResultException(e);
            }
        }
    }

    public void startElement(String name, String namespaceURI) throws IllegalNameException, IllegalNodeException, ResultException {
        this.closeStartTag();
        if (!XMLUtil.isQName(name)) {
            throw new IllegalNameException();
        }
        this.pushState();
        this.elementName = name;
        this.startTagOpen = true;
        this.attributeNames.clear();
        this.attributeValues.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String name) throws ResultException {
        block5: {
            try {
                this.closeStartTag();
                if (this.documentHandler == null) break block5;
                try {
                    this.documentHandler.endElement(name);
                }
                catch (SAXException e) {
                    throw new ResultException(e);
                }
            }
            finally {
                this.popState();
            }
        }
    }

    public void attribute(String name, String value) throws AttributeAfterChildException, IllegalNameException, IllegalNodeException, ResultException {
        ExpandedQName expandedName;
        if (this.elementName == null) {
            throw new IllegalNodeException();
        }
        if (this.startTagOpen) {
            if (!XMLUtil.isQName(name)) {
                throw new IllegalNameException();
            }
            expandedName = this.getExpandedName(name, true);
            for (int i = 0; i < this.attributeNames.size(); ++i) {
                if (!expandedName.equals((ExpandedQName)this.attributeNames.get(i))) continue;
                this.attributeNames.set(i, expandedName);
                this.attributeValues.set(i, value);
                return;
            }
        } else {
            throw new AttributeAfterChildException();
        }
        this.attributeNames.add(expandedName);
        this.attributeValues.add(value);
    }

    public void characters(String data) throws IllegalNodeException, ResultException {
        this.closeStartTag();
        if (this.documentHandler != null) {
            try {
                char[] chars = data.toCharArray();
                this.documentHandler.characters(chars, 0, chars.length);
            }
            catch (SAXException e) {
                throw new ResultException(e);
            }
        }
    }

    public void processingInstruction(String target, String value) throws IllegalNameException, IllegalNodeException, ResultException {
        if (!XMLUtil.isPITarget(target)) {
            throw new IllegalNameException();
        }
        this.closeStartTag();
        if (this.documentHandler != null) {
            try {
                this.documentHandler.processingInstruction(target, value);
            }
            catch (SAXException e) {
                throw new ResultException(e);
            }
        }
    }

    public void comment(String value) throws IllegalNodeException, ResultException {
        this.closeStartTag();
        if (this.documentHandler != null) {
            try {
                if (this.documentHandler instanceof DocumentCommentHandler) {
                    ((DocumentCommentHandler)this.documentHandler).comment(value);
                } else if (this.doPIComments) {
                    this.documentHandler.processingInstruction(null, value);
                }
            }
            catch (SAXException e) {
                throw new ResultException(e);
            }
        }
    }

    public void namespace(String name, NamespaceName value) throws IllegalNodeException, ResultException {
        if (!this.startTagOpen) {
            throw new IllegalNodeException();
        }
        if (this.currentNamespaces.add(name, value)) {
            String attrName = name.length() > 0 ? "xmlns:" + name : "xmlns";
            this.attribute(attrName, value.getString());
        }
    }

    public void setLocale(Locale locale) throws SAXException {
    }

    public void setEntityResolver(EntityResolver resolver) {
    }

    public void setDTDHandler(DTDHandler handler) {
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this.documentHandler = handler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public void parse(InputSource source) throws SAXException, IOException {
        Document document;
        if (this.stylesheet == null) {
            throw new SAXException("SAXResultHandler: no stylesheet associated with object");
        }
        boolean preStripped = false;
        if (this.sourceDocument == null) {
            if (this.parser == null) {
                XMLParser xmlParser = XMLParserFactory.newParser();
                if (xmlParser instanceof SAXParserImpl) {
                    ((SAXParserImpl)xmlParser).setConverter(new SAXtoDOMStrip(DocumentImpl.newDocument(), this.stylesheet.getStripList()));
                    preStripped = true;
                }
                document = xmlParser.parse(source);
                if (xmlParser.anyErrors()) {
                    throw new SAXException(xmlParser.getErrorMsgString());
                }
            } else {
                SAXtoDOMStrip converter = new SAXtoDOMStrip(DocumentImpl.newDocument(), this.stylesheet.getStripList());
                this.parser.setDocumentHandler(converter);
                this.parser.setDTDHandler(converter);
                this.parser.parse(source);
                document = converter.getResult();
                preStripped = true;
            }
        } else {
            document = this.sourceDocument;
        }
        this.stylesheet.setResultHandler(this);
        URL sourceURL = null;
        String systemId = source.getSystemId();
        if (systemId != null) {
            sourceURL = new URL(systemId);
        }
        try {
            this.stylesheet.process(document, sourceURL, preStripped);
        }
        catch (XSLException e) {
            throw new SAXException(e);
        }
    }

    public void parse(String systemId) throws SAXException, IOException {
        this.parse(new InputSource(systemId));
    }

    protected void closeStartTag() throws ResultException {
        if (this.startTagOpen) {
            this.startTagOpen = false;
            if (this.documentHandler != null) {
                this.attrList.clear();
                for (int i = 0; i < this.attributeNames.size(); ++i) {
                    this.attrList.addAttribute(((ExpandedQName)this.attributeNames.get(i)).getQName(), "CDATA", (String)this.attributeValues.get(i));
                }
                try {
                    this.documentHandler.startElement(this.elementName, this.attrList);
                }
                catch (SAXException e) {
                    throw new ResultException(e);
                }
            }
        }
    }

    protected ExpandedQName getExpandedName(String qName, boolean isAttribute) throws IllegalNameException {
        String local;
        String prefix;
        int index = qName.indexOf(58);
        if (index == -1 || isAttribute && qName.startsWith("xmlns")) {
            if (isAttribute) {
                return new ExpandedQName("", qName, "");
            }
            prefix = "";
            local = qName;
        } else {
            prefix = qName.substring(0, index);
            local = qName.substring(index + 1, qName.length());
        }
        NamespaceName nsName = this.currentNamespaces.getNamespaceName(prefix);
        if (nsName == null) {
            throw new IllegalNameException();
        }
        return new ExpandedQName(nsName, local, prefix);
    }

    protected void pushState() {
        this.stateStack.push(this.elementName);
        this.currentNamespaces.push();
    }

    protected void popState() {
        this.currentNamespaces.pop();
        this.elementName = (String)this.stateStack.pop();
    }
}

