/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.result;

import com.novell.io.EncodingStreamWriter;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.Serializer;
import com.novell.xsl.result.SerializerOptions;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public abstract class SerializerImpl
implements Serializer {
    protected SerializerOptions options = new SerializerOptions();
    protected Writer writer;
    protected OutputStream stream;
    protected String actualEncoding;

    public SerializerOptions getOptions() {
        return this.options;
    }

    public void setOptions(SerializerOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("XMLSerializer.setOptions: null options");
        }
        this.options = options;
    }

    public OutputStream getStream() {
        return this.stream;
    }

    public void setStream(OutputStream stream) {
        this.stream = stream;
        this.writer = null;
    }

    public void noTextEscaping(boolean noEscape) {
    }

    protected void initWriter() throws ResultException {
        if (this.writer == null) {
            try {
                if (this.options.getEncoding() == null || this.options.getEncoding().length() == 0) {
                    this.writer = new EncodingStreamWriter(this.stream, "UTF-8");
                    this.actualEncoding = ((EncodingStreamWriter)this.writer).getEncoding();
                } else {
                    try {
                        this.writer = new EncodingStreamWriter(this.stream, this.options.getEncoding());
                        this.actualEncoding = ((EncodingStreamWriter)this.writer).getEncoding();
                    }
                    catch (UnsupportedEncodingException e) {
                        this.writer = new OutputStreamWriter(this.stream, this.options.getEncoding());
                        this.actualEncoding = this.options.getEncoding();
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                try {
                    this.writer = new EncodingStreamWriter(this.stream, "UTF-8");
                    this.actualEncoding = ((EncodingStreamWriter)this.writer).getEncoding();
                }
                catch (UnsupportedEncodingException e1) {
                    throw new ResultException(e1.getMessage());
                }
            }
        }
    }
}

