/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.result;

import com.novell.xml.util.ExpandedQName;
import java.util.Collection;
import java.util.Iterator;

public class SerializerOptions {
    private ExpandedQName method = null;
    private String version = null;
    private boolean indent = false;
    private String encoding = null;
    private String mediaType = null;
    private String doctypeSystem = null;
    private String doctypePublic = null;
    private boolean declaration = false;
    private boolean standalone = false;
    private Collection cdataSectionElements = null;
    private int flags = 0;
    private static int INDENT_SET = 1;
    private static int DECLARATION_SET = 2;
    private static int STANDALONE_SET = 4;

    public ExpandedQName getMethod() {
        return this.method;
    }

    public void setMethod(ExpandedQName method) {
        this.method = method;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean getIndent() {
        return this.indent;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
        this.flags |= INDENT_SET;
    }

    public boolean wasIndentSet() {
        return (this.flags & INDENT_SET) != 0;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String getDoctypeSystem() {
        return this.doctypeSystem;
    }

    public void setDoctypeSystem(String doctypeSystem) {
        this.doctypeSystem = doctypeSystem;
    }

    public String getDoctypePublic() {
        return this.doctypePublic;
    }

    public void setDoctypePublic(String doctypePublic) {
        this.doctypePublic = doctypePublic;
    }

    public boolean getDeclaration() {
        return this.declaration;
    }

    public void setDeclaration(boolean declaration) {
        this.declaration = declaration;
        this.flags |= DECLARATION_SET;
    }

    public boolean wasDeclarationSet() {
        return (this.flags & DECLARATION_SET) != 0;
    }

    public boolean getStandalone() {
        return this.declaration;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
        this.flags |= STANDALONE_SET;
    }

    public boolean wasStandaloneSet() {
        return (this.flags & STANDALONE_SET) != 0;
    }

    public Collection getCdataSectionElements() {
        return this.cdataSectionElements;
    }

    public void setCdataSectionElements(Collection cdataSectionElements) {
        this.cdataSectionElements = cdataSectionElements;
    }

    public void merge(SerializerOptions rhs) {
        if (this.method == null || this.method.getLocalPart().length() == 0) {
            this.method = rhs.method;
        }
        if (this.version == null || this.version.length() == 0) {
            this.version = rhs.version;
        }
        if ((this.flags & INDENT_SET) != 0) {
            this.indent = rhs.indent;
            this.flags = this.flags & ~INDENT_SET | rhs.flags & INDENT_SET;
        }
        if (this.encoding == null || this.encoding.length() == 0) {
            this.encoding = rhs.encoding;
        }
        if (this.mediaType == null || this.mediaType.length() == 0) {
            this.mediaType = rhs.mediaType;
        }
        if (this.doctypeSystem == null || this.doctypeSystem.length() == 0) {
            this.doctypeSystem = rhs.doctypeSystem;
        }
        if (this.doctypePublic == null || this.doctypePublic.length() == 0) {
            this.doctypePublic = rhs.doctypePublic;
        }
        if ((this.flags & DECLARATION_SET) != 0) {
            this.declaration = rhs.declaration;
            this.flags = this.flags & ~DECLARATION_SET | rhs.flags & DECLARATION_SET;
        }
        if ((this.flags & STANDALONE_SET) != 0) {
            this.standalone = rhs.standalone;
            this.flags = this.flags & ~STANDALONE_SET | rhs.flags & STANDALONE_SET;
        }
        if (this.cdataSectionElements == null || this.cdataSectionElements.isEmpty()) {
            this.cdataSectionElements = rhs.cdataSectionElements;
        } else if (rhs.cdataSectionElements != null && !rhs.cdataSectionElements.isEmpty()) {
            Iterator it = rhs.cdataSectionElements.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (this.cdataSectionElements.contains(obj)) continue;
                this.cdataSectionElements.add(obj);
            }
        }
    }
}

