/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.result;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.NamespaceStack;
import com.novell.xml.util.XMLUtil;
import com.novell.xsl.debug.Assert;
import com.novell.xsl.result.AttributeAfterChildException;
import com.novell.xsl.result.IllegalNameException;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.result.Serializer;
import com.novell.xsl.result.SerializerImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;

public class XMLSerializer
extends SerializerImpl
implements ResultHandler,
Serializer {
    protected int elementCount = 0;
    protected boolean startTagOpen = false;
    protected boolean noEscape = false;
    protected boolean forceDTD = false;
    protected int indentLevel = 0;
    protected int nodeType = -1;
    protected List attributeNames = new ArrayList(16);
    protected List attributeValues = new ArrayList(16);
    protected boolean children = false;
    protected String elementName;
    protected NamespaceStack currentNamespaces = new NamespaceStack();
    protected boolean cdataOutput = false;
    protected Stack stateStack = new Stack();
    protected static final int XML_SPACE_DEFAULT = 0;
    protected static final int XML_SPACE_PRESERVE = 1;
    protected static final Integer xmlSpaceDefault = new Integer(0);
    protected static final Integer xmlSpacePreserve = new Integer(1);
    protected int xmlSpace = 0;

    public XMLSerializer() {
    }

    public XMLSerializer(OutputStream stream) {
        this.setStream(stream);
    }

    public void startDocument() throws ResultException {
        try {
            this.initWriter();
            this.initState();
            if (this.options.getDeclaration()) {
                this.writer.write("<?xml version=\"1.0\"");
                this.writer.write(" encoding=\"");
                this.writer.write(this.actualEncoding);
                this.writer.write(34);
                if (this.options.getStandalone()) {
                    this.writer.write(" standalone=\"yes\"");
                }
                this.writer.write("?>");
                if (this.options.getIndent() && this.xmlSpace != 1) {
                    this.writer.write(10);
                    this.nodeType = 3;
                }
            }
        }
        catch (IOException e) {
            throw new ResultException(e);
        }
    }

    public void endDocument() throws ResultException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new ResultException(e);
        }
    }

    public void startElement(String name, String namespaceURI) throws IllegalNameException, IllegalNodeException, ResultException {
        try {
            if (!XMLUtil.isQName(name)) {
                throw new IllegalNameException();
            }
            if (this.elementCount == 0 && (this.forceDTD || this.options.getDoctypeSystem() != null && this.options.getDoctypeSystem().length() > 0)) {
                this.writeDTD(name);
            }
            ++this.elementCount;
            this.children = true;
            this.pushState();
            this.closeStartTag();
            this.children = false;
            this.elementName = name;
            this.cdataOutput = this.useCdataOutput(name);
            this.attributeNames.clear();
            this.attributeValues.clear();
            this.injectWhitespace(1, this.nodeType);
            this.writer.write(60);
            this.writer.write(name);
            this.startTagOpen = true;
            ++this.indentLevel;
            this.nodeType = 1;
        }
        catch (IOException e) {
            throw new ResultException(e);
        }
    }

    public void endElement(String name) throws ResultException {
        try {
            Assert.assertCondition(!this.stateStack.empty(), "XMLSerializer: too many calls to endElement()");
            if (!this.children) {
                this.closeStartTag();
            } else {
                if (this.options.getIndent() && this.nodeType != 3 && this.xmlSpace != 1) {
                    this.writer.write(10);
                    this.doIndent(this.indentLevel - 1);
                }
                this.writer.write("</");
                this.writer.write(name);
                this.writer.write(62);
            }
            --this.indentLevel;
            this.popState();
            this.nodeType = 1;
        }
        catch (IOException e) {
            throw new ResultException(e);
        }
    }

    public void attribute(String name, String value) throws AttributeAfterChildException, IllegalNameException, IllegalNodeException, ResultException {
        if (this.elementName == null) {
            throw new IllegalNodeException();
        }
        if (this.startTagOpen) {
            if (!XMLUtil.isQName(name)) {
                throw new IllegalNameException();
            }
            ExpandedQName expandedName = this.getExpandedName(name, true);
            for (int i = 0; i < this.attributeNames.size(); ++i) {
                if (!expandedName.equals((ExpandedQName)this.attributeNames.get(i))) continue;
                this.attributeNames.set(i, expandedName);
                this.attributeValues.set(i, value);
                return;
            }
            this.attributeNames.add(expandedName);
            this.attributeValues.add(value);
            if (name.equals("xml:space")) {
                this.xmlSpace = value.equals("preserve") ? 1 : 0;
            }
        } else {
            throw new AttributeAfterChildException();
        }
    }

    public void characters(String data) throws IllegalNodeException, ResultException {
        try {
            this.children = true;
            this.closeStartTag();
            if (this.noEscape) {
                this.writer.write(data);
            } else if (this.cdataOutput) {
                XMLUtil.encodeAsCData(this.writer, data);
            } else {
                XMLUtil.encodeText(this.writer, data);
            }
            this.nodeType = 3;
        }
        catch (IOException e) {
            throw new ResultException(e);
        }
    }

    public void processingInstruction(String target, String value) throws IllegalNameException, IllegalNodeException, ResultException {
        try {
            if (!XMLUtil.isPITarget(target)) {
                throw new IllegalNameException();
            }
            this.children = true;
            this.closeStartTag();
            this.injectWhitespace(7, this.nodeType);
            this.writer.write("<?");
            this.writer.write(target);
            if (value != null && value.length() > 0) {
                this.writer.write(32);
                this.writer.write(value);
            }
            this.writer.write("?>");
            this.nodeType = 7;
        }
        catch (IOException e) {
            throw new ResultException(e);
        }
    }

    public void comment(String value) throws IllegalNodeException, ResultException {
        try {
            this.children = true;
            this.closeStartTag();
            this.injectWhitespace(8, this.nodeType);
            this.writer.write("<!--");
            this.writer.write(value);
            this.writer.write("-->");
            this.nodeType = 8;
        }
        catch (IOException e) {
            throw new ResultException(e);
        }
    }

    public void namespace(String name, NamespaceName value) throws IllegalNodeException, ResultException {
        if (!this.startTagOpen) {
            throw new IllegalNodeException();
        }
        if (this.currentNamespaces.add(name, value)) {
            String attrName = name.length() > 0 ? "xmlns:" + name : "xmlns";
            this.attribute(attrName, value.getString());
        }
    }

    public void noTextEscaping(boolean noEscape) {
        this.noEscape = noEscape;
    }

    protected void writeDTD(String name) throws IOException {
        this.writer.write("<!DOCTYPE ");
        this.writer.write(name);
        String doctypePublic = this.options.getDoctypePublic();
        String doctypeSystem = this.options.getDoctypeSystem();
        if (doctypePublic != null && doctypePublic.length() > 0) {
            this.writer.write(" PUBLIC ");
            int quote = doctypePublic.indexOf(34) != -1 ? 39 : 34;
            this.writer.write(quote);
            this.writer.write(doctypePublic);
            this.writer.write(quote);
            this.writer.write(32);
            quote = doctypeSystem.indexOf(34) != -1 ? 39 : 34;
            this.writer.write(quote);
            this.writer.write(doctypeSystem);
            this.writer.write(quote);
        } else {
            this.writer.write(" SYSTEM ");
            int quote = doctypeSystem.indexOf(34) != -1 ? 39 : 34;
            this.writer.write(quote);
            this.writer.write(doctypeSystem);
            this.writer.write(quote);
        }
        this.writer.write(" >");
    }

    protected void closeStartTag() throws IOException, ResultException {
        if (this.startTagOpen) {
            this.startTagOpen = false;
            for (int i = 0; i < this.attributeNames.size(); ++i) {
                this.outputXMLAttribute((ExpandedQName)this.attributeNames.get(i), (String)this.attributeValues.get(i));
            }
            if (this.children) {
                this.writer.write(62);
            } else {
                this.writer.write("/>");
            }
        }
    }

    protected void injectWhitespace(int nodeType, int lastNodeType) throws IOException {
        if (!this.options.getIndent() || this.xmlSpace == 1) {
            return;
        }
        switch (nodeType) {
            case 1: 
            case 7: 
            case 8: {
                if (lastNodeType == 3) break;
                this.writer.write(10);
                this.doIndent(this.indentLevel);
                break;
            }
        }
    }

    protected void doIndent(int level) throws IOException {
        for (int i = 0; i < level; ++i) {
            this.writer.write(9);
        }
    }

    protected boolean useCdataOutput(String name) throws IllegalNameException {
        Collection elements = this.options.getCdataSectionElements();
        if (elements == null || elements.isEmpty()) {
            return false;
        }
        return elements.contains(this.getExpandedName(name, false));
    }

    protected void initState() {
        this.elementCount = 0;
        this.startTagOpen = false;
        this.noEscape = false;
        this.indentLevel = 0;
        this.nodeType = -1;
        this.forceDTD = false;
    }

    protected void pushState() {
        this.stateStack.push(this.children ? Boolean.TRUE : Boolean.FALSE);
        this.stateStack.push(this.elementName);
        this.stateStack.push(this.cdataOutput ? Boolean.TRUE : Boolean.FALSE);
        this.stateStack.push(this.xmlSpace == 0 ? xmlSpaceDefault : xmlSpacePreserve);
        this.currentNamespaces.push();
    }

    protected void popState() {
        this.currentNamespaces.pop();
        this.xmlSpace = (Integer)this.stateStack.pop();
        this.cdataOutput = (Boolean)this.stateStack.pop();
        this.elementName = (String)this.stateStack.pop();
        this.children = (Boolean)this.stateStack.pop();
    }

    protected ExpandedQName getExpandedName(String qName, boolean isAttribute) throws IllegalNameException {
        String local;
        String prefix;
        int index = qName.indexOf(58);
        if (index == -1 || isAttribute && qName.startsWith("xmlns")) {
            if (isAttribute) {
                return new ExpandedQName("", qName, "");
            }
            prefix = "";
            local = qName;
        } else {
            prefix = qName.substring(0, index);
            local = qName.substring(index + 1, qName.length());
        }
        NamespaceName nsName = this.currentNamespaces.getNamespaceName(prefix);
        if (nsName == null) {
            throw new IllegalNameException();
        }
        return new ExpandedQName(nsName, local, prefix);
    }

    protected void outputXMLAttribute(ExpandedQName name, String value) throws IOException {
        this.writer.write(32);
        String prefix = name.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            this.writer.write(prefix);
            this.writer.write(58);
        }
        this.writer.write(name.getLocalPart());
        this.writer.write(61);
        XMLUtil.encodeAttribute(this.writer, value);
    }
}

