/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.util;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.WildcardName;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.Stylesheet;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Util {
    public static final String SPACE_DEFAULT = "default";
    public static final String SPACE_PRESERVE = "preserve";

    private Util() {
    }

    public static String getXSLStringValue(Node node) {
        switch (node.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                return Util.getElementStringValue(node);
            }
        }
        return XPathUtil.getNodeValue(node);
    }

    private static String getElementStringValue(Node node) {
        Node childNode = node.getFirstChild();
        if (childNode == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(256);
        do {
            switch (childNode.getNodeType()) {
                case 1: 
                case 9: {
                    buffer.append(Util.getElementStringValue(childNode));
                    break;
                }
                default: {
                    buffer.append(childNode.getNodeValue());
                }
            }
        } while ((childNode = childNode.getNextSibling()) != null);
        return buffer.toString();
    }

    public static String getXSLStringValue(List nodeList) {
        return nodeList.isEmpty() ? "" : Util.getXSLStringValue((Node)nodeList.get(0));
    }

    public static Locale parseLang(String lang) throws IllegalArgumentException {
        if (lang != null && lang.length() > 0) {
            String country = "";
            String variant = "";
            switch (lang.length()) {
                default: {
                    if (lang.charAt(5) != '-' || lang.charAt(6) == '-') break;
                    int i = lang.indexOf(45, 7);
                    variant = i > 0 ? lang.substring(6, i) : lang.substring(6);
                }
                case 5: {
                    if (lang.charAt(2) != '-' || lang.charAt(3) == '-' || lang.charAt(4) == '-') break;
                    country = lang.substring(3, 5);
                }
                case 2: {
                    if (lang.charAt(0) == '-' || lang.charAt(1) == '-') break;
                    return new Locale(lang.substring(0, 2), country, variant);
                }
                case 0: 
                case 1: 
                case 3: 
                case 4: 
                case 6: 
            }
            throw new IllegalArgumentException();
        }
        return Locale.getDefault();
    }

    public static String unicodeEscape(char ch) {
        String str = Integer.toHexString(ch);
        return "\\u" + "0000".substring(str.length()) + str;
    }

    public static boolean stripWhitespaceNode(Node node) {
        ExpandedQName name;
        Node parent;
        short type = node.getNodeType();
        if (!(type != 3 && type != 4 || !XMLUtil.isXMLWhitespace(node.getNodeValue()) || (parent = node.getParentNode()) == null || parent.getNodeType() != 1 || (name = DOMUtil.getExpandedName(parent)).localPartEquals("text") && name.namespaceNameEquals(Stylesheet.NAMESPACE))) {
            while (parent != null) {
                Attr attr;
                if (parent.getNodeType() == 1 && (attr = ((Element)parent).getAttributeNode("xml:space")) != null) {
                    String value = attr.getNodeValue();
                    if (value.equals(SPACE_PRESERVE)) {
                        return false;
                    }
                    if (value.equals(SPACE_DEFAULT)) {
                        return true;
                    }
                }
                parent = parent.getParentNode();
            }
            return true;
        }
        return false;
    }

    public static double getWildcardNamePriority(WildcardName name) {
        if (name.isFullWild()) {
            return -0.5;
        }
        if (name.isLocalWild()) {
            return -0.25;
        }
        return 0.0;
    }

    public static void indent(PrintWriter writer, int tabs) {
        for (int i = 0; i < tabs; ++i) {
            writer.print("\t");
        }
    }
}

