/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.common.exceptions;

import com.novell.admin.common.exceptions.MessageLinkResourceBundle;
import com.novell.admin.common.exceptions.SPIException;
import java.text.MessageFormat;
import java.util.MissingResourceException;

public class LDAPSPIException
extends SPIException {
    public static final String ERR_CODE = "(Error {0}) ";
    int errorCode = 0;
    String className = null;
    String funcName = null;
    String crackedError;

    public LDAPSPIException(String bundleName) {
        super(bundleName);
    }

    private LDAPSPIException(MessageLinkResourceBundle bundle, int errorCode, String className, String funcName, Throwable throwable) {
        super(bundle, true);
        this.errorCode = errorCode;
        this.className = className;
        this.funcName = funcName;
        this.crackedError = this.crackErrorCode();
        this.setHelpID(bundle.getHelpId(this.crackedError + funcName));
        if (this.getHelpID() == null) {
            this.setHelpID(bundle.getHelpId(this.crackedError));
        }
        this.setCause(throwable);
    }

    public SPIException newException(int errorCode, String funcName, Throwable throwable) {
        return new LDAPSPIException(this.bundle, errorCode, "", funcName, throwable);
    }

    public SPIException newException(int errorCode, String className, String funcName, Throwable throwable) {
        return new LDAPSPIException(this.bundle, errorCode, className, funcName, throwable);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getFunctionName() {
        return this.funcName;
    }

    public String getLocalizedMessage() {
        String message = "";
        String err = "";
        err = MessageFormat.format("(" + this.bundle.getLocalizedMessage("Error") + "{0})", new Integer(this.errorCode));
        try {
            message = err + this.bundle.getLocalizedMessage(this.funcName);
        }
        catch (MissingResourceException exception1) {
            try {
                message = err + this.bundle.getLocalizedMessage(this.funcName);
            }
            catch (MissingResourceException exception2) {
                message = this.bundle.getUnknownErrorMessage(this.funcName);
            }
        }
        return message;
    }
}

