/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.common.util;

import com.novell.admin.common.util.EndianOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EndianOutputStream
extends DataOutputStream
implements EndianOutput {
    public EndianOutputStream(OutputStream out) {
        super(out);
    }

    public final void writeHiLoChars(String s) throws IOException {
        this.writeChars(s);
        this.writeChar(0);
    }

    public final void writeLoHiChars(String s) throws IOException {
        OutputStream out = this.out;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            out.write(v >>> 0 & 0xFF);
            out.write(v >>> 8 & 0xFF);
        }
        this.written += len * 2;
        this.writeChar(0);
    }

    public final void writeHiLoInt(int v) throws IOException {
        this.writeInt(v);
    }

    public final void writeLoHiInt(int v) throws IOException {
        OutputStream out = this.out;
        out.write(v >>> 0 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 24 & 0xFF);
        this.written += 4;
    }

    public final void writeHiLoShort(int v) throws IOException {
        this.writeShort(v);
    }

    public final void writeLoHiShort(int v) throws IOException {
        OutputStream out = this.out;
        out.write(v >>> 0 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        this.written += 2;
    }

    public final void writeHiLoLong(long v) throws IOException {
        this.writeLong(v);
    }

    public final void writeLoHiLong(long v) throws IOException {
        OutputStream out = this.out;
        out.write((int)(v >>> 0) & 0xFF);
        out.write((int)(v >>> 8) & 0xFF);
        out.write((int)(v >>> 16) & 0xFF);
        out.write((int)(v >>> 24) & 0xFF);
        out.write((int)(v >>> 32) & 0xFF);
        out.write((int)(v >>> 40) & 0xFF);
        out.write((int)(v >>> 48) & 0xFF);
        out.write((int)(v >>> 56) & 0xFF);
        this.written += 8;
    }

    public final void pad(int n) throws IOException {
        OutputStream out = this.out;
        int len = this.written % n;
        for (int i = 0; i < len; ++i) {
            out.write(0);
        }
        this.written += len;
    }
}

