/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.common.exceptions.AdminNamespaceExceptionReference;
import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.ValueComponent;
import com.novell.application.console.snapin.Debug;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class DefaultNSObject
extends NSObject
implements Serializable {
    protected ObjectEntry objectEntry;
    protected Hashtable addedAttributeDefinitions = new Hashtable();
    protected AdminNamespace namespace = null;
    private static final int CANT_SET_CLASSDEF = 1;

    protected DefaultNSObject(ObjectEntry objEntry, Vector attributes, long rev) {
        this.objectEntry = objEntry;
        this.namespace = (AdminNamespace)objEntry.getObjectType().getNamespace();
        this.revision = rev;
        this.putAttributes(attributes);
    }

    public void addAttribute(ObjectAttribute attr) throws NamespaceException {
        this.addAttribute(attr, false);
    }

    private void addAttribute(ObjectAttribute attr, boolean isForAuxClass) throws NamespaceException {
        String attrName = attr.getName();
        String attrNameLower = attrName.toLowerCase();
        this.checkAdd(attr, isForAuxClass);
        if (attr.getComponentCount() == 0) {
            throw NamespaceException.ATTRIBUTE_NOT_VALUED;
        }
        this.attributes.put(attrNameLower, attr);
        if (this.deletedAttributes.contains(attrNameLower)) {
            this.deletedAttributes.removeElement(attrNameLower);
            this.modifiedAttributes.addElement(attrNameLower);
        } else if (!this.addedAttributes.contains(attrNameLower)) {
            this.addedAttributes.addElement(attrNameLower);
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, attrName, null, attrName);
        this.notifyPropertyChangeListeners(event);
    }

    public ObjectAttribute getAttribute(String attrName) {
        ObjectAttribute attribute = null;
        try {
            attribute = this.getAttribute(attrName, null, null);
        }
        catch (NamespaceException x) {
            Debug.out("DefaultNSObject exception reading \"" + attrName + "\": " + x.toString());
        }
        catch (SPIException x) {
            Debug.out("DefaultNSObject exception reading \"" + attrName + "\": " + x.toString());
        }
        return attribute;
    }

    public ObjectAttribute getAttribute(String attrName, AdminNamespaceExceptionReference aneRef, ObjectEntry serverOE) throws SPIException, NamespaceException {
        return this.getAttribute(attrName, 0, aneRef, serverOE);
    }

    public ObjectAttribute getAttribute(String attrName, int attrFlags, AdminNamespaceExceptionReference aneRef, ObjectEntry serverOE) throws SPIException, NamespaceException {
        Object attr;
        ObjectAttribute attribute = null;
        if (aneRef != null) {
            aneRef.setAdminNamespaceException(null);
        }
        if ((attr = this.attributes.get(attrName.toLowerCase())) instanceof ObjectAttribute) {
            attribute = (ObjectAttribute)attr;
        } else if (attr instanceof String) {
            try {
                String[] attrs = new String[]{(String)attr};
                ObjectAttribute[] objectAttributes = aneRef == null ? this.namespace.getAttributes(this.objectEntry, attrs, attrFlags, serverOE) : this.namespace.getAttributes(this.objectEntry, attrs, 4 | attrFlags, aneRef, serverOE);
                if (objectAttributes != null && objectAttributes.length > 0 && objectAttributes[0] != null) {
                    attribute = objectAttributes[0];
                    this.attributes.put(attrName.toLowerCase(), attribute);
                    attribute.addPropertyChangeListener(this);
                } else {
                    this.attributes.remove(attrName.toLowerCase());
                }
            }
            catch (NamespaceException x) {
                this.attributes.remove(attrName.toLowerCase());
                throw x;
            }
            catch (SPIException x) {
                this.attributes.remove(attrName.toLowerCase());
                throw x;
            }
        }
        return attribute;
    }

    public boolean deleteAttribute(String attrName) throws NamespaceException {
        return this.deleteAttribute(attrName, false);
    }

    private boolean deleteAttribute(String attrName, boolean isForAuxClass) throws NamespaceException {
        String attrNameLower = attrName.toLowerCase();
        try {
            if (this.namespace.getAttributeDefinition(this.objectEntry, attrName).isReadOnly()) {
                throw NamespaceException.READONLY_ATTRIBUTE;
            }
        }
        catch (SPIException sPIException) {
            // empty catch block
        }
        if (!isForAuxClass && this.isAttributeMandatory(attrName)) {
            throw NamespaceException.MANDATORY_ATTRIBUTE;
        }
        ObjectAttribute oldAttr = this.getAttribute(attrName);
        if (oldAttr == null) {
            return false;
        }
        if (!this.addedAttributes.removeElement(attrNameLower)) {
            if (this.modifiedAttributes.removeElement(attrNameLower)) {
                this.deletedAttributes.addElement(attrNameLower);
            } else if (!this.deletedAttributes.contains(attrNameLower)) {
                this.deletedAttributes.addElement(attrNameLower);
                oldAttr.removePropertyChangeListener(this);
            }
        }
        this.attributes.remove(attrNameLower);
        PropertyChangeEvent event = new PropertyChangeEvent(this, attrName, attrName, null);
        this.notifyPropertyChangeListeners(event);
        return true;
    }

    public String[] getAddedAttributes() {
        String[] addedAttrs = new String[this.addedAttributes.size()];
        for (int i = 0; i < this.addedAttributes.size(); ++i) {
            addedAttrs[i] = ((ObjectAttribute)this.attributes.get(this.addedAttributes.elementAt(i))).getName();
        }
        return addedAttrs;
    }

    public Hashtable getAddedAttributeDefinitions() {
        return this.addedAttributeDefinitions;
    }

    public String[] getAttributes() {
        Vector<String> vec = new Vector<String>(this.attributes.size());
        Enumeration myenum = this.attributes.elements();
        while (myenum.hasMoreElements()) {
            Object attr = myenum.nextElement();
            if (attr instanceof ObjectAttribute) {
                vec.addElement(((ObjectAttribute)attr).getName());
                continue;
            }
            if (!(attr instanceof String)) continue;
            vec.addElement((String)attr);
        }
        Object[] attrs = new String[vec.size()];
        vec.copyInto(attrs);
        return attrs;
    }

    public String[] getMandatoryAttributes() {
        Vector<String> vec = new Vector<String>();
        Enumeration myenum = this.attributes.elements();
        while (myenum.hasMoreElements()) {
            String name = ((ObjectAttribute)myenum.nextElement()).getName();
            if (!this.isAttributeMandatory(name)) continue;
            vec.addElement(name);
        }
        Object[] attrs = new String[vec.size()];
        vec.copyInto(attrs);
        return attrs;
    }

    public String[] getOptionalAttributes() {
        Vector<String> vec = new Vector<String>();
        Enumeration myenum = this.attributes.elements();
        while (myenum.hasMoreElements()) {
            String name = ((ObjectAttribute)myenum.nextElement()).getName();
            if (!this.isAttributeOptional(name)) continue;
            vec.addElement(name);
        }
        Object[] attrs = new String[vec.size()];
        vec.copyInto(attrs);
        return attrs;
    }

    public String[] getUnvaluedAttributes() {
        Vector<String> vec = new Vector<String>();
        AttributeDefinition[] attrDefs = this.getOptionalAttributeDefinitions();
        for (int i = 0; i < attrDefs.length; ++i) {
            ObjectAttribute attr = this.getAttribute(attrDefs[i].getName());
            if (attr != null || attrDefs[i].isHidden()) continue;
            vec.addElement(attrDefs[i].getName());
        }
        Object[] attrs = new String[vec.size()];
        vec.copyInto(attrs);
        return attrs;
    }

    public ClassDefinition[] getClassDefinitions() {
        this.setClassDefinition();
        Object[] classDefs = new ClassDefinition[this.classDefinition.size()];
        this.classDefinition.copyInto(classDefs);
        return classDefs;
    }

    public String[] getDeletedAttributes() {
        Object[] attrs = new String[this.deletedAttributes.size()];
        this.deletedAttributes.copyInto(attrs);
        return attrs;
    }

    public String[] getModifiedAttributes() {
        String[] attrs = new String[this.modifiedAttributes.size()];
        for (int i = 0; i < this.modifiedAttributes.size(); ++i) {
            attrs[i] = ((ObjectAttribute)this.attributes.get(this.modifiedAttributes.elementAt(i))).getName();
        }
        return attrs;
    }

    public ObjectEntry getObjectEntry() {
        return this.objectEntry;
    }

    public long getRevision() {
        return this.revision;
    }

    public NSObject clone(ObjectEntry newIdentity) throws NamespaceException {
        int i;
        ObjectType[] newObjectTypes;
        DefaultNSObject newNSObject = null;
        if (newIdentity.getObjectType() != this.objectEntry.getObjectType()) {
            throw NamespaceException.OBJECTTYPE_NOT_VALID;
        }
        ObjectType[] oldObjectTypes = this.objectEntry.getSubTypes();
        if (oldObjectTypes.length == (newObjectTypes = newIdentity.getSubTypes()).length) {
            throw NamespaceException.OBJECTTYPE_NOT_VALID;
        }
        Vector<ObjectType> objectTypeVec = new Vector<ObjectType>(oldObjectTypes.length);
        for (i = 0; i < oldObjectTypes.length; ++i) {
            objectTypeVec.addElement(oldObjectTypes[i]);
        }
        for (i = 0; i < oldObjectTypes.length; ++i) {
            if (objectTypeVec.contains(newObjectTypes[i])) continue;
            throw NamespaceException.OBJECTTYPE_NOT_VALID;
        }
        newNSObject = (DefaultNSObject)this.clone();
        newNSObject.objectEntry = newIdentity;
        return newNSObject;
    }

    public boolean addAuxiliaryClassDefinition(ClassDefinition classDef, ObjectAttribute[] attrs) throws NamespaceException {
        int i;
        boolean rval = true;
        Vector<Object> mandatoryAttributesVec = new Vector<Object>();
        if (!classDef.isAuxiliary()) {
            throw NamespaceException.NOT_AUXILIARY_CLASS;
        }
        Object[] mandatoryAttrDefs = classDef.getMandatoryAttributes();
        for (int j = 0; j < mandatoryAttrDefs.length; ++j) {
            if (this.attributes.get(mandatoryAttrDefs[j].getName().toLowerCase()) != null) continue;
            mandatoryAttributesVec.addElement(mandatoryAttrDefs[j]);
        }
        mandatoryAttrDefs = new AttributeDefinition[mandatoryAttributesVec.size()];
        mandatoryAttributesVec.copyInto(mandatoryAttrDefs);
        if (!this.shadowSign && mandatoryAttrDefs.length != 0) {
            if (attrs == null || attrs.length == 0) {
                throw NamespaceException.MISSING_MANDATORY_ATTRIBUTE;
            }
            Vector<AttributeDefinition> attrDefVec = new Vector<AttributeDefinition>(attrs.length);
            for (i = 0; i < attrs.length; ++i) {
                attrDefVec.addElement(attrs[i].getAttributeDefinition());
            }
            for (i = 0; i < mandatoryAttrDefs.length; ++i) {
                if (attrDefVec.contains(mandatoryAttrDefs[i])) continue;
                throw NamespaceException.MISSING_MANDATORY_ATTRIBUTE;
            }
        }
        AttributeDefinition[] auxMandAttr = classDef.getMandatoryAttributes();
        for (i = 0; i < auxMandAttr.length; ++i) {
            this.addedAttributeDefinitions.put(auxMandAttr[i].getName(), auxMandAttr[i].getName());
        }
        AttributeDefinition[] auxOptAttr = classDef.getOptionalAttributes();
        for (i = 0; i < auxOptAttr.length; ++i) {
            if (this.isClassUsingAttribute(auxOptAttr[i].getName())) continue;
            this.addedAttributeDefinitions.put(auxOptAttr[i].getName(), auxOptAttr[i].getName());
        }
        this.setClassDefinition();
        this.classDefinition.addElement(classDef);
        if (attrs != null) {
            for (i = 0; i < attrs.length; ++i) {
                try {
                    ObjectAttribute oa = this.getAttribute(attrs[i].getName());
                    if (oa == null) {
                        this.addAttribute(attrs[i], true);
                        continue;
                    }
                    if (oa.getAttributeDefinition().isSingleValued()) {
                        oa.removeAllComponents();
                    }
                    Enumeration myenum = attrs[i].getValueComponents();
                    while (myenum.hasMoreElements()) {
                        oa.addComponent((ValueComponent)myenum.nextElement());
                    }
                    continue;
                }
                catch (NamespaceException x) {
                    rval = false;
                }
            }
        }
        return rval;
    }

    public boolean deleteAuxiliaryClassDefinition(ClassDefinition classDef) throws NamespaceException {
        ObjectAttribute oldAttr;
        String attrName;
        int i;
        if (!classDef.isAuxiliary()) {
            throw NamespaceException.NOT_AUXILIARY_CLASS;
        }
        this.setClassDefinition();
        if (!this.classDefinition.removeElement(classDef)) {
            return false;
        }
        AttributeDefinition[] mandatoryAttr = classDef.getMandatoryAttributes();
        AttributeDefinition[] optionalAttr = classDef.getOptionalAttributes();
        for (i = 0; i < mandatoryAttr.length; ++i) {
            attrName = mandatoryAttr[i].getName();
            if (this.isClassUsingAttribute(attrName)) continue;
            oldAttr = (ObjectAttribute)this.attributes.remove(attrName.toLowerCase());
            if (oldAttr != null) {
                oldAttr.removePropertyChangeListener(this);
            }
            this.addedAttributeDefinitions.remove(attrName);
        }
        for (i = 0; i < optionalAttr.length; ++i) {
            attrName = optionalAttr[i].getName();
            if (this.isClassUsingAttribute(attrName)) continue;
            oldAttr = (ObjectAttribute)this.attributes.remove(attrName.toLowerCase());
            if (oldAttr != null) {
                oldAttr.removePropertyChangeListener(this);
            }
            this.addedAttributeDefinitions.remove(attrName);
        }
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        ObjectAttribute attr = (ObjectAttribute)event.getSource();
        attr.removePropertyChangeListener(this);
        this.modifiedAttributes.addElement(attr.getName().toLowerCase());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.propertyListeners.contains(listener)) {
            this.propertyListeners.addElement(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.removeElement(listener);
    }

    public void clearAddedAttribute(String attrName) {
        this.addedAttributes.removeElement(attrName.toLowerCase());
        ObjectAttribute attr = (ObjectAttribute)this.attributes.get(attrName.toLowerCase());
        if (attr != null) {
            attr.addPropertyChangeListener(this);
        }
    }

    public void clearAddedAttributeDefinitions() {
        this.addedAttributeDefinitions.clear();
    }

    public void clearDeletedAttribute(String attrName) {
        this.deletedAttributes.removeElement(attrName.toLowerCase());
    }

    public void clearModifiedAttribute(String attrName) {
        this.modifiedAttributes.removeElement(attrName.toLowerCase());
        ObjectAttribute attr = (ObjectAttribute)this.attributes.get(attrName.toLowerCase());
        if (attr != null) {
            attr.addPropertyChangeListener(this);
        }
    }

    private void putAttributes(Vector attributes) {
        if (attributes != null) {
            this.attributes = new Hashtable(attributes.size() + 1);
            Enumeration e = attributes.elements();
            while (e.hasMoreElements()) {
                Object attr = e.nextElement();
                if (attr instanceof ObjectAttribute) {
                    ObjectAttribute objAttr = (ObjectAttribute)attr;
                    String attrName = objAttr.getName();
                    if (this.classDefinition != null && !this.isClassUsingAttribute(attrName)) continue;
                    this.attributes.put(attrName.toLowerCase(), objAttr);
                    objAttr.addPropertyChangeListener(this);
                    continue;
                }
                if (!(attr instanceof String)) continue;
                this.attributes.put(((String)attr).toLowerCase(), attr);
            }
        } else {
            this.attributes = new Hashtable(10);
        }
    }

    protected void checkAdd(ObjectAttribute attr, boolean isForAuxClass) throws NamespaceException {
        String attrName = attr.getName();
        AttributeDefinition attrDef = attr.getAttributeDefinition();
        if (attrDef.isReadOnly()) {
            throw NamespaceException.READONLY_ATTRIBUTE;
        }
        if (!this.shadowSign && !attrDef.isOperational()) {
            if (!isForAuxClass && this.isAttributeMandatory(attrName)) {
                throw NamespaceException.MANDATORY_ATTRIBUTE;
            }
            if (isForAuxClass && !this.isAttributeMandatory(attrName) && !this.isAttributeOptional(attrName)) {
                throw NamespaceException.INVALID_ATTRIBUTE;
            }
            if (!isForAuxClass && !this.isAttributeOptional(attrName)) {
                throw NamespaceException.INVALID_ATTRIBUTE;
            }
        }
        if (this.getAttribute(attrName) != null) {
            throw NamespaceException.DUPLICATE_ATTRIBUTE;
        }
    }

    public boolean isAddPossible(ObjectAttribute attr, boolean isForAuxClass) throws NamespaceException {
        boolean isPossible = true;
        String attrName = attr.getName();
        AttributeDefinition attrDef = attr.getAttributeDefinition();
        if (attrDef.isReadOnly()) {
            return false;
        }
        if (!this.shadowSign && !attrDef.isOperational()) {
            if (!isForAuxClass && this.isAttributeMandatory(attrName)) {
                return false;
            }
            if (isForAuxClass && !this.isAttributeMandatory(attrName) && !this.isAttributeOptional(attrName)) {
                return false;
            }
            if (!isForAuxClass && !this.isAttributeOptional(attrName)) {
                return false;
            }
        }
        if (this.getAttribute(attrName) != null) {
            isPossible = false;
            throw NamespaceException.DUPLICATE_ATTRIBUTE;
        }
        return isPossible;
    }

    public boolean isAttributeMandatory(String attrName) {
        this.setClassDefinition();
        Enumeration myenum = this.classDefinition.elements();
        while (myenum.hasMoreElements()) {
            if (!((ClassDefinition)myenum.nextElement()).isAttributeMandatory(attrName)) continue;
            return true;
        }
        return false;
    }

    public boolean isAttributeOptional(String attrName) {
        this.setClassDefinition();
        Enumeration myenum = this.classDefinition.elements();
        while (myenum.hasMoreElements()) {
            if (!((ClassDefinition)myenum.nextElement()).isAttributeOptional(attrName)) continue;
            return true;
        }
        return false;
    }

    public boolean isNamedBy(String attrName) {
        this.setClassDefinition();
        Enumeration myenum = this.classDefinition.elements();
        while (myenum.hasMoreElements()) {
            if (!((ClassDefinition)myenum.nextElement()).isNamedBy(attrName)) continue;
            return true;
        }
        return false;
    }

    private boolean isClassUsingAttribute(String attrName) {
        this.setClassDefinition();
        Enumeration myenum = this.classDefinition.elements();
        while (myenum.hasMoreElements()) {
            if (!((ClassDefinition)myenum.nextElement()).isClassUsingAttribute(attrName)) continue;
            return true;
        }
        return false;
    }

    private AttributeDefinition[] getOptionalAttributeDefinitions() {
        Vector<AttributeDefinition> tempVec = new Vector<AttributeDefinition>();
        this.setClassDefinition();
        Enumeration myenum = this.classDefinition.elements();
        while (myenum.hasMoreElements()) {
            AttributeDefinition[] attrDefs = ((ClassDefinition)myenum.nextElement()).getOptionalAttributes();
            for (int j = 0; j < attrDefs.length; ++j) {
                tempVec.addElement(attrDefs[j]);
            }
        }
        Object[] optionalAttributes = new AttributeDefinition[tempVec.size()];
        tempVec.copyInto(optionalAttributes);
        return optionalAttributes;
    }

    private void notifyPropertyChangeListeners(PropertyChangeEvent event) {
        Vector listeners = (Vector)this.propertyListeners.clone();
        Enumeration e = listeners.elements();
        while (e.hasMoreElements()) {
            PropertyChangeListener pl = (PropertyChangeListener)e.nextElement();
            pl.propertyChange(event);
        }
    }

    protected void setClassDefinition() {
        if (this.classDefinition != null) {
            return;
        }
        try {
            this.classDefinition = new Vector(5);
            this.classDefinition.addElement(this.namespace.getClassDefinition(this.objectEntry, this.objectEntry.getObjectType().getName()));
            String OBJECT_CLASS = SchemaUtil.translateNDAPAttr(this.objectEntry, "Object Class");
            ObjectAttribute objClassAttr = this.getAttribute(OBJECT_CLASS);
            if (objClassAttr != null) {
                Enumeration values = objClassAttr.getValueComponents();
                while (values.hasMoreElements()) {
                    ClassDefinition classDef = this.namespace.getClassDefinition(this.objectEntry, values.nextElement().toString());
                    if (classDef == null || !classDef.isAuxiliary()) continue;
                    this.classDefinition.addElement(classDef);
                }
            }
        }
        catch (SPIException ex) {
            throw new AdminError(1, this.getClass());
        }
        catch (NamespaceException ex) {
            throw new AdminError(1, this.getClass());
        }
    }
}

