/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.ResultModifierFilterEntry;
import java.util.Vector;

public class FilterResultModifier
extends ResultModifier {
    public static final String OR = "|";
    public static final String AND = "&";
    public static final String EQUAL = "=";
    public static final String NOT_EQUAL = "!";
    public static final String GREATER_OR_EQUAL = ">=";
    public static final String LESS_OR_EQUAL = "<=";
    public static final String APPROX = "~=";
    public static final String PRESENT = "=*";
    public static final String NOT_PRESENT = "!*";
    private Vector filters = new Vector();

    public FilterResultModifier(String descriptiveName, Filter filter, boolean subContainer) {
        super(descriptiveName);
        this.setSubContainerSearch(subContainer);
        if (filter != null) {
            this.filters.addElement(filter);
        }
    }

    public FilterResultModifier(String descriptiveName, int sortKey, Filter filter, boolean subContainer) {
        super(descriptiveName, sortKey, 0, new ResultModifierFilterEntry("", null), subContainer);
        if (filter != null) {
            this.filters.addElement(filter);
        }
    }

    public FilterResultModifier(String descriptiveName, int sortKey, Filter filter, boolean subContainer, boolean subClasses) {
        super(descriptiveName, sortKey, 0, new ResultModifierFilterEntry("", null), subContainer, subClasses);
        if (filter != null) {
            this.filters.addElement(filter);
        }
    }

    public void addFilter(Filter filter) {
        if (filter != null) {
            this.filters.addElement(filter);
        }
    }

    public Filter[] getFRMFilters() {
        Filter[] filterArray = new Filter[this.filters.size()];
        filterArray = this.filters.toArray(filterArray);
        return filterArray;
    }

    public Filter getFilter() {
        if (this.filters.size() == 0) {
            return null;
        }
        return (Filter)this.filters.firstElement();
    }

    protected String getComplexFilterString(AdminNamespace namespace) {
        if (this.filters.size() == 0) {
            return "";
        }
        boolean eDir = true;
        try {
            if (namespace != null && namespace.isSupported("NVDS")) {
                eDir = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Filter filter = (Filter)this.filters.firstElement();
        StringBuffer fb = new StringBuffer();
        Filter.FilterItemGroupPair[] groupPairs = filter.getFilterItemGroupPairs();
        String filterTypeName = filter.getFilterTypeName();
        String typeFilterString = "";
        if (filterTypeName != null && filterTypeName.length() > 0) {
            typeFilterString = this.getTypeFilterString(new String[]{filterTypeName}, eDir, namespace);
        }
        if (typeFilterString.length() > 0 && groupPairs.length > 0) {
            fb.append("(&");
        }
        fb.append(typeFilterString);
        if (groupPairs.length > 1) {
            fb.append("(");
            fb.append(groupPairs[0].getLogicalFilter());
        }
        for (int i = 0; i < groupPairs.length; ++i) {
            FilterItemGroup filterItemGroup = groupPairs[i].getFilterItemGroup();
            FilterItemGroup.FilterItem[] filterItems = filterItemGroup.getFilterItems();
            if (filterItems.length > 1 && filterItems[0].getLogicalFilter() != null) {
                fb.append("(");
                fb.append(filterItems[0].getLogicalFilter());
            }
            for (int j = 0; j < filterItems.length; ++j) {
                String compareFilter = filterItems[j].getCompareFilter();
                if (compareFilter.equals(NOT_EQUAL)) {
                    fb.append("(!(");
                    fb.append(filterItems[j].getAttributeName());
                    fb.append(EQUAL);
                    fb.append(filterItems[j].getAttributeValue());
                    fb.append("))");
                    continue;
                }
                if (compareFilter.equals(NOT_PRESENT)) {
                    fb.append("(!(");
                    fb.append(filterItems[j].getAttributeName());
                    fb.append("=*))");
                    continue;
                }
                fb.append("(");
                fb.append(filterItems[j].getAttributeName());
                fb.append(compareFilter);
                fb.append(filterItems[j].getAttributeValue());
                fb.append(")");
            }
            if (filterItems.length <= 1 || filterItems[0].getLogicalFilter() == null) continue;
            fb.append(")");
        }
        if (groupPairs.length > 1) {
            fb.append(")");
        }
        if (typeFilterString.length() > 0 && groupPairs.length > 0) {
            fb.append(")");
        }
        return fb.toString();
    }

    public boolean equals(Object resMod) {
        boolean isEqual = false;
        if (this == resMod) {
            isEqual = true;
        } else if (resMod instanceof FilterResultModifier && super.equals(resMod) && this.toString().equals(resMod.toString())) {
            isEqual = true;
        }
        return isEqual;
    }

    public static class Filter {
        private Vector filter = new Vector();
        private String filterTypeName = null;

        public Filter() {
            this.filterTypeName = null;
        }

        public Filter(String typeName) {
            this.filterTypeName = typeName;
        }

        public String getFilterTypeName() {
            return this.filterTypeName;
        }

        public void addFilterItemGroupPair(FilterItemGroup group, String logicalFilter) {
            this.filter.addElement(new FilterItemGroupPair(group, logicalFilter));
        }

        public FilterItemGroupPair[] getFilterItemGroupPairs() {
            Object[] filterArray = new FilterItemGroupPair[this.filter.size()];
            this.filter.copyInto(filterArray);
            return filterArray;
        }

        public class FilterItemGroupPair {
            private FilterItemGroup group;
            private String logicalFilter;

            public FilterItemGroupPair(FilterItemGroup group, String logicalFilter) {
                this.group = group;
                this.logicalFilter = logicalFilter;
            }

            public FilterItemGroup getFilterItemGroup() {
                return this.group;
            }

            public String getLogicalFilter() {
                return this.logicalFilter;
            }
        }
    }

    public static class FilterItemGroup {
        private Vector filterItems = new Vector();

        public void addFilterItem(String attributeName, String compareFilter, String attributeValue, String logicalFilter) {
            FilterItem filterItem = new FilterItem(attributeName, compareFilter, attributeValue, logicalFilter);
            this.filterItems.addElement(filterItem);
        }

        public FilterItem[] getFilterItems() {
            Object[] filterItemArray = new FilterItem[this.filterItems.size()];
            this.filterItems.copyInto(filterItemArray);
            return filterItemArray;
        }

        public class FilterItem {
            private String attributeName;
            private String compareFilter;
            private String attributeValue;
            private String logicalFilter;

            FilterItem(String attributeName, String compareFilter, String attributeValue, String logicalFilter) {
                this.attributeName = attributeName;
                this.compareFilter = compareFilter;
                this.attributeValue = attributeValue;
                this.logicalFilter = logicalFilter;
            }

            public String getAttributeName() {
                return this.attributeName;
            }

            public String getCompareFilter() {
                return this.compareFilter;
            }

            public String getAttributeValue() {
                return this.attributeValue;
            }

            public String getLogicalFilter() {
                return this.logicalFilter;
            }
        }
    }
}

