/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueStrategy;

public abstract class IntegerStrategy
implements ValueStrategy {
    private static final int BAD_EQUAL_OBJ = 1;
    private static final int BAD_COMPARE_OBJ = 2;
    protected static final int WITHIN_BOUNDS = 3;
    private static final int BAD_TOSTRING_OBJ = 4;

    public boolean equals(ValueComponent component1, ValueComponent component2) {
        if (component1 instanceof LongValue) {
            if (component1.getSyntax() == component2.getSyntax()) {
                LongValue v1 = (LongValue)component1;
                LongValue v2 = (LongValue)component2;
                return v1.getValue() == v2.getValue();
            }
            return false;
        }
        throw new AdminError(1, this.getClass());
    }

    public long compare(ValueComponent component1, ValueComponent component2) {
        if (component1 instanceof LongValue && component2 instanceof LongValue) {
            if (component1.getSyntax() != component2.getSyntax()) {
                return component1.getSyntax().getId() - component2.getSyntax().getId();
            }
            LongValue v1 = (LongValue)component1;
            LongValue v2 = (LongValue)component2;
            return v1.getValue() - v2.getValue();
        }
        throw new AdminError(2, this.getClass());
    }

    public String toString(ValueComponent obj) {
        if (obj instanceof LongValue) {
            return ((LongValue)obj).getLongValue().toString();
        }
        throw new AdminError(4, this.getClass());
    }

    public boolean canCreateValue(Object obj) {
        if (obj instanceof Number) {
            return true;
        }
        if (obj instanceof String) {
            try {
                Long.parseLong((String)obj);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public ValueComponent createValueComponent(Object obj) throws ComponentCreationException {
        if (obj instanceof Number) {
            return new LongValue(this.getSyntax(), ((Number)obj).longValue());
        }
        if (obj instanceof String) {
            try {
                return new LongValue(this.getSyntax(), Long.parseLong((String)obj));
            }
            catch (NumberFormatException e) {
                throw new ComponentCreationException();
            }
        }
        throw new ComponentCreationException();
    }

    public ValueComponent createValueComponent() {
        return new LongValue(this.getSyntax(), 0L);
    }

    public boolean isWithinBounds(ValueComponent comp, long lowerBound, long upperBound) {
        if (comp instanceof LongValue) {
            LongValue val = (LongValue)comp;
            long i = val.getValue();
            return i >= lowerBound && i <= upperBound;
        }
        throw new AdminError(3, this.getClass());
    }
}

