/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import java.util.Enumeration;
import java.util.Hashtable;

public class NSUtil {
    public static final String os_unknown = "unknown";
    public static final String os_aix = "aix";
    public static final String os_hpux = "hpux";
    public static final String os_linux = "linux";
    public static final String os_netware = "netware";
    public static final String os_solaris = "solaris";
    public static final String os_windows = "windows";
    private static String osName = null;

    public static void copyIntoArray(Hashtable hashtable, Object[] anArray) {
        Enumeration e = hashtable.keys();
        for (int i = 0; e.hasMoreElements() && i < anArray.length; ++i) {
            anArray[i] = hashtable.get((String)e.nextElement());
        }
    }

    public static String toHexString(byte[] bytes) {
        byte[] buf = new byte[bytes.length * 2];
        int index = 0;
        for (int offset = 0; offset < bytes.length; ++offset) {
            int i = 1;
            while (i >= 0) {
                byte b = (byte)(bytes[offset] >> i * 4 & 0xF);
                b = b <= 9 ? (byte)(b + 48) : (byte)(b + 87);
                buf[index] = b;
                --i;
                ++index;
            }
        }
        String lowerCaseString = new String(buf);
        String upperCaseString = lowerCaseString.toUpperCase();
        return upperCaseString;
    }

    public static int byteToDecimal(byte b) {
        int value = new Byte(b).intValue();
        if (value < 0) {
            return value + 256;
        }
        return value;
    }

    public static byte[] hexStringToByteArray(String str) throws NumberFormatException {
        int numChars = str.length();
        int byteCount = numChars / 2 + numChars % 2;
        byte[] rval = new byte[byteCount];
        int byteIndex = 0;
        int nibbleCount = 0;
        byte byteValue = 0;
        for (int index = 0; index < numChars; ++index) {
            char nibble = str.charAt(numChars - index - 1);
            if (nibble >= '0' && nibble <= '9') {
                nibble = (char)(nibble - 48);
            } else if (nibble >= 'a' && nibble <= 'f') {
                nibble = (char)(nibble - 97);
                nibble = (char)(nibble + 10);
            } else if (nibble >= 'A' && nibble <= 'F') {
                nibble = (char)(nibble - 65);
                nibble = (char)(nibble + 10);
            } else {
                throw new NumberFormatException();
            }
            if (nibbleCount % 2 == 0) {
                byteValue = (byte)(nibble & 0xF);
            } else {
                byteValue = (byte)(byteValue | (byte)(nibble << 4));
                rval[byteIndex++] = byteValue;
            }
            ++nibbleCount;
        }
        if (nibbleCount % 2 != 0) {
            rval[byteIndex] = byteValue;
        }
        return NSUtil.reverseBytes(rval);
    }

    public static byte[] reverseBytes(byte[] bytes) {
        int len = bytes.length;
        byte[] r = new byte[len];
        for (int i = 0; i < len; ++i) {
            r[i] = bytes[len - i - 1];
        }
        return r;
    }

    public static String getPlatform() {
        if (osName == null) {
            String ostmp = System.getProperty("os.name");
            osName = ostmp.startsWith("Linux") ? os_linux : (ostmp.startsWith("Windows") ? os_windows : (ostmp.startsWith("Solaris") || ostmp.startsWith("SunOS") ? os_solaris : (ostmp.startsWith("NetWare") ? os_netware : (ostmp.startsWith("HP-UX") ? os_hpux : (ostmp.startsWith("AIX") ? os_aix : os_unknown)))));
        }
        return osName;
    }

    public static void main(String[] st) {
        Hashtable<String, Integer> ht = new Hashtable<String, Integer>();
        ht.put("One", new Integer(1));
        ht.put("Two", new Integer(2));
        ht.put("Three", new Integer(3));
        ht.put("Four", new Integer(4));
        ht.put("Five", new Integer(5));
        ht.put("Six", new Integer(6));
        Object[] array = new Integer[ht.size()];
        NSUtil.copyIntoArray(ht, array);
        for (int i = 0; i < 6; ++i) {
            System.out.println((Integer)array[i]);
        }
    }
}

