/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.ValueComponent;
import java.util.Enumeration;

public class ObjectOperation {
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int SET = 3;
    public static final int CLEAR = 4;
    public static final int IGNORE = 5;
    protected ObjectAttribute m_objectAttribute = null;
    protected int m_mode = -1;

    public ObjectOperation(ObjectAttribute objAttr, int mode) throws NamespaceException {
        this.m_objectAttribute = objAttr;
        switch (mode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.m_mode = mode;
                break;
            }
            default: {
                throw NamespaceException.UNSUPPORTED_OPERATION;
            }
        }
    }

    public ObjectAttribute getObjectAttribute() {
        return this.m_objectAttribute;
    }

    public int getMode() {
        return this.m_mode;
    }

    public void addComponent(ValueComponent comp) throws NamespaceException {
        this.m_objectAttribute.addComponent(comp);
    }

    public void addComponents(ValueComponent[] comps) throws NamespaceException {
        this.m_objectAttribute.addComponents(comps);
    }

    public int getComponentCount() {
        return this.m_objectAttribute.getComponentCount();
    }

    public Enumeration getValueComponents() {
        return this.m_objectAttribute.getValueComponents();
    }

    public AttributeDefinition getAttributeDefinition() {
        return this.m_objectAttribute.getAttributeDefinition();
    }

    public String getName() {
        return this.m_objectAttribute.getName();
    }

    public void removeAllComponents() {
        this.m_objectAttribute.removeAllComponents();
    }
}

