/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;

public class SchemaCacheManager {
    private Hashtable schemaCache = new Hashtable();
    private Hashtable attributeCache = new Hashtable();
    private static SchemaCacheManager instance = null;
    private static final String MODIFY_TIME_STAMP = "modifyTimeStamp";

    private SchemaCacheManager() {
    }

    public static SchemaCacheManager getInstance() {
        if (instance == null) {
            instance = new SchemaCacheManager();
        }
        return instance;
    }

    public DirContext getLDAPSchema(String sourceObj, DirContext ctx, String host, String schemaName, String username) throws NamingException {
        String key = host + ":" + schemaName + ":" + username;
        DirContext schema = (DirContext)this.schemaCache.get(key);
        if (schema == null) {
            schema = ctx.getSchema(sourceObj);
            Attribute modifyTimeStamp = this.getLDAPSchemaAttribute(MODIFY_TIME_STAMP, host, username, ctx, schemaName);
            if (modifyTimeStamp != null) {
                if (this.schemaCache.size() > 4) {
                    Enumeration myenum = this.schemaCache.keys();
                    while (myenum.hasMoreElements()) {
                        this.schemaCache.remove(myenum.nextElement());
                    }
                }
                this.schemaCache.put(key, schema);
                this.attributeCache.put(key + ":" + MODIFY_TIME_STAMP, modifyTimeStamp.get());
            }
        } else {
            String modifiedTimeStamp = (String)this.getLDAPSchemaAttribute(MODIFY_TIME_STAMP, host, username, ctx, schemaName).get();
            if (!modifiedTimeStamp.equals(this.attributeCache.get(key + ":" + MODIFY_TIME_STAMP))) {
                schema = ctx.getSchema(sourceObj);
                if (this.schemaCache.size() > 4) {
                    Enumeration myenum = this.schemaCache.keys();
                    while (myenum.hasMoreElements()) {
                        this.schemaCache.remove(myenum.nextElement());
                    }
                }
                this.schemaCache.put(key, schema);
                this.attributeCache.put(key + ":" + MODIFY_TIME_STAMP, modifiedTimeStamp);
            }
        }
        return schema;
    }

    public Attribute getLDAPSchemaAttribute(String attribute, String host, String username, DirContext ctx, String sourceObject) throws NamingException {
        String key = host + ":" + username;
        Attribute retVal = (Attribute)this.attributeCache.get(key + ":" + attribute);
        if (retVal == null && (retVal = ctx.getAttributes(sourceObject, new String[]{attribute}).get(attribute)) != null) {
            if (this.attributeCache.size() > 21) {
                Enumeration myenum = this.attributeCache.keys();
                while (myenum.hasMoreElements()) {
                    this.attributeCache.remove(myenum.nextElement());
                }
            }
            this.attributeCache.put(key + ":" + attribute, retVal);
        }
        return retVal;
    }

    public Attributes getLDAPSchemaAttributes(String[] attributes, String host, String username, DirContext ctx, String sourceObject, String schemaName) throws NamingException {
        StringBuffer attributesKey = new StringBuffer();
        for (int i = 0; i < attributes.length; ++i) {
            attributesKey.append(attributes[i] + ":");
        }
        Attributes retVal = (Attributes)this.attributeCache.get(host + ":" + username + ":" + attributesKey);
        if (retVal == null) {
            retVal = ctx.getAttributes(sourceObject, attributes);
            if (retVal != null) {
                if (this.attributeCache.size() > 21) {
                    Enumeration myenum = this.attributeCache.keys();
                    while (myenum.hasMoreElements()) {
                        this.attributeCache.remove(myenum.nextElement());
                    }
                }
                this.attributeCache.put(host + ":" + username + ":" + attributesKey, retVal);
            }
        } else {
            String modifiedTimeStamp = (String)this.getLDAPSchemaAttribute(MODIFY_TIME_STAMP, host, username, ctx, schemaName).get();
            if (!modifiedTimeStamp.equals(this.attributeCache.get(host + ":" + schemaName + ":" + username + ":" + MODIFY_TIME_STAMP))) {
                retVal = ctx.getAttributes(sourceObject, attributes);
            }
        }
        return retVal;
    }
}

