/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.application.console.snapin.NamespaceSnapin;
import com.novell.application.console.snapin.ObjectType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class SchemaDefinition
implements Cloneable,
Serializable {
    protected HashMap attributes;
    protected HashMap classes;
    protected HashMap expandedClasses;
    protected HashMap aliasClassNames;
    protected HashMap aliasAttributeNames;
    protected HashMap objectTypeCache = new HashMap();
    protected NamespaceSnapin namespace = null;
    private static final int CLONE_NOT_SUPPORTED = 1;

    public SchemaDefinition(NamespaceSnapin ns2) {
        this.attributes = new HashMap(1000);
        this.classes = new HashMap(200);
        this.expandedClasses = new HashMap(200);
        this.aliasClassNames = new HashMap(3);
        this.aliasAttributeNames = new HashMap(3);
        this.namespace = ns2;
    }

    public SchemaDefinition() {
        this(null);
    }

    public final int getNumberOfAttributes() {
        return this.attributes.size();
    }

    public final int getNumberOfClasses() {
        return this.expandedClasses.size();
    }

    public ClassDefinition[] getAuxiliaryClassDefinitions() {
        ArrayList<ClassDefinition> alist = new ArrayList<ClassDefinition>();
        for (ClassDefinition classDef : this.expandedClasses.values()) {
            if (!classDef.isAuxiliary()) continue;
            alist.add(classDef);
        }
        return alist.toArray(new ClassDefinition[0]);
    }

    public ClassDefinition[] getClassDefinitions() {
        return this.expandedClasses.values().toArray(new ClassDefinition[0]);
    }

    public ClassDefinition[] getRawClassDefinitions() {
        return this.classes.values().toArray(new ClassDefinition[0]);
    }

    public AttributeDefinition[] getAttributeDefinitions() {
        return this.attributes.values().toArray(new AttributeDefinition[0]);
    }

    public ClassDefinition[] getClassesUsingAttribute(String attrName) {
        ArrayList<ClassDefinition> alist = new ArrayList<ClassDefinition>();
        for (ClassDefinition classDef : this.expandedClasses.values()) {
            if (!classDef.isClassUsingAttribute(attrName)) continue;
            alist.add(classDef);
        }
        return alist.toArray(new ClassDefinition[0]);
    }

    public AttributeDefinition getAttributeDefinition(String attrName) throws NamespaceException {
        if (attrName == null) {
            throw NamespaceException.INVALID_ATTRIBUTE;
        }
        AttributeDefinition ad = (AttributeDefinition)this.attributes.get(attrName = attrName.toLowerCase());
        if (ad != null) {
            return ad;
        }
        String realName = (String)this.aliasAttributeNames.get(attrName.toLowerCase());
        if (realName != null && (ad = (AttributeDefinition)this.attributes.get(realName.toLowerCase())) != null) {
            return ad;
        }
        throw NamespaceException.ATTRIBUTE_NOT_DEFINED;
    }

    public boolean canContain(String parentClass, String childClass) {
        try {
            parentClass = this.translateAliasClassName(parentClass);
            if (!this.getClassDefinition(parentClass).isContainer()) {
                return false;
            }
            return this.getClassDefinition(childClass).canBeContainedBy(parentClass);
        }
        catch (NamespaceException namespaceException) {
            return false;
        }
    }

    public ClassDefinition[] getContainmentClasses(String className) throws NamespaceException {
        ClassDefinition classDef = this.getClassDefinition(className);
        String[] cont = classDef.getContainmentClasses();
        ClassDefinition[] classDefs = new ClassDefinition[cont.length];
        for (int i = 0; i < cont.length; ++i) {
            classDefs[i] = this.getRawClassDefinition(cont[i]);
        }
        return classDefs;
    }

    public ClassDefinition[] getEffectiveClasses(String parentClass) {
        ArrayList<ClassDefinition> effectives = new ArrayList<ClassDefinition>();
        try {
            if (!this.getRawClassDefinition(parentClass).isContainer()) {
                return new ClassDefinition[0];
            }
            for (ClassDefinition cd : this.expandedClasses.values()) {
                if (!cd.isEffective() || !this.canContain(parentClass, cd.getName())) continue;
                effectives.add(cd);
            }
            return effectives.toArray(new ClassDefinition[0]);
        }
        catch (NamespaceException namespaceException) {
            return null;
        }
    }

    public ClassDefinition getClassDefinition(String className) throws NamespaceException {
        ClassDefinition cd = (ClassDefinition)this.expandedClasses.get((className = className.toLowerCase()).toLowerCase());
        if (cd != null) {
            return cd;
        }
        String realName = (String)this.aliasClassNames.get(className.toLowerCase());
        if (realName != null && (cd = (ClassDefinition)this.expandedClasses.get(realName.toLowerCase())) != null) {
            return cd;
        }
        throw NamespaceException.CLASS_NOT_DEFINED;
    }

    public ClassDefinition getRawClassDefinition(String className) throws NamespaceException {
        ClassDefinition cd = (ClassDefinition)this.classes.get(className.toLowerCase());
        if (cd != null) {
            return cd;
        }
        String realName = (String)this.aliasClassNames.get(className.toLowerCase());
        if (realName != null && (cd = (ClassDefinition)this.classes.get(realName.toLowerCase())) != null) {
            return cd;
        }
        throw NamespaceException.CLASS_NOT_DEFINED;
    }

    public final boolean isClassDefined(String className) {
        String classLower = this.translateAliasClassName(className).toLowerCase();
        return this.classes.containsKey(classLower) || this.aliasClassNames.containsKey(classLower);
    }

    public final boolean isAttributeDefined(String attrName) {
        String attrLower = this.translateAliasAttributeName(attrName).toLowerCase();
        return this.attributes.containsKey(attrLower) || this.aliasAttributeNames.containsKey(attrLower);
    }

    public ClassDefinition[] getSubClasses(String className) {
        ArrayList<ClassDefinition> alist = new ArrayList<ClassDefinition>();
        if (className != null) {
            className = this.translateAliasClassName(className);
            for (ClassDefinition cd : this.expandedClasses.values()) {
                if (!cd.isInheritedFrom(className)) continue;
                alist.add(cd);
            }
        }
        return alist.toArray(new ClassDefinition[0]);
    }

    public ClassDefinition[] getSuperClasses(String className) throws NamespaceException {
        if (className == null) {
            return new ClassDefinition[0];
        }
        String[] superClassNames = this.getClassDefinition(className).getSuperClasses();
        ClassDefinition[] classDefs = new ClassDefinition[superClassNames.length];
        for (int i = 0; i < superClassNames.length; ++i) {
            classDefs[i] = this.getRawClassDefinition(superClassNames[i]);
        }
        return classDefs;
    }

    public AttributeDefinition[] getNamingAttributes(String className) throws NamespaceException {
        return this.getClassDefinition(className).getNamingAttributes();
    }

    public AttributeDefinition[] getOptionalAttributes(String className) throws NamespaceException {
        return this.getClassDefinition(className).getOptionalAttributes();
    }

    public AttributeDefinition[] getMandatoryAttributes(String className) throws NamespaceException {
        return this.getClassDefinition(className).getMandatoryAttributes();
    }

    public String translateAliasAttributeName(String oldName) {
        String newName;
        if (oldName != null && (newName = (String)this.aliasAttributeNames.get(oldName.toLowerCase())) != null) {
            return newName;
        }
        return oldName;
    }

    public String translateAliasClassName(String oldName) {
        String newName;
        if (oldName != null && (newName = (String)this.aliasClassNames.get(oldName.toLowerCase())) != null) {
            return newName;
        }
        return oldName;
    }

    public ObjectType getObjectType(String className) throws SPIException {
        ObjectType ot = (ObjectType)this.objectTypeCache.get(className.toLowerCase());
        if (ot != null) {
            return ot;
        }
        try {
            ClassDefinition classDef = this.getRawClassDefinition(className);
            String[] objectSuperClasses = classDef.getSuperClasses();
            int numberOfSuperClasses = objectSuperClasses.length;
            if (numberOfSuperClasses > 0) {
                ObjectType[] ota = new ObjectType[numberOfSuperClasses];
                for (int i = 0; i < numberOfSuperClasses; ++i) {
                    ota[i] = this.getObjectType(objectSuperClasses[i]);
                }
                ot = new ObjectType(className, this.namespace, classDef.isContainer(), ota);
            } else {
                ot = new ObjectType(className, this.namespace, classDef.isContainer());
            }
            this.objectTypeCache.put(className.toLowerCase(), ot);
            return ot;
        }
        catch (NamespaceException x) {
            return null;
        }
    }

    public synchronized Object clone() {
        try {
            SchemaDefinition sd = (SchemaDefinition)super.clone();
            sd.attributes = (HashMap)this.attributes.clone();
            sd.classes = (HashMap)this.classes.clone();
            sd.expandedClasses = (HashMap)this.expandedClasses.clone();
            sd.aliasAttributeNames = (HashMap)this.aliasAttributeNames.clone();
            sd.aliasClassNames = (HashMap)this.aliasClassNames.clone();
            sd.objectTypeCache = (HashMap)this.objectTypeCache.clone();
            sd.namespace = this.namespace;
            return sd;
        }
        catch (CloneNotSupportedException e) {
            throw new AdminError(1, this.getClass());
        }
    }

    public void clearAttributes() {
        this.attributes.clear();
        this.aliasAttributeNames.clear();
    }

    public void clearClasses() {
        this.classes.clear();
        this.aliasClassNames.clear();
    }

    public void clearObjectTypeCache() {
        this.objectTypeCache.clear();
    }
}

