/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.InputStreamFactory;
import com.novell.admin.ns.StreamValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueStrategy;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class StreamStrategy
implements ValueStrategy {
    private static final int DISPLAY_FIELD_WIDTH = 256;
    private static final int BAD_EQUAL_OBJ = 1;
    private static final int BAD_COMPARE_OBJ = 2;
    private static final int WITHIN_BOUNDS = 3;

    public boolean canCreateValue(Object obj) {
        return obj instanceof StreamValue || obj instanceof InputStreamFactory;
    }

    public ValueComponent createValueComponent() {
        return new StreamValue(this.getSyntax(), new EmptyStreamFactory());
    }

    public ValueComponent createValueComponent(Object obj) throws ComponentCreationException {
        if (obj instanceof InputStreamFactory) {
            return new StreamValue(this.getSyntax(), (InputStreamFactory)obj);
        }
        if (obj instanceof StreamValue) {
            return new StreamValue(this.getSyntax(), ((StreamValue)obj).getStreamFactory());
        }
        throw new ComponentCreationException();
    }

    public boolean equals(ValueComponent obj1, ValueComponent obj2) {
        if (obj1 instanceof StreamValue) {
            return obj1 == obj2;
        }
        throw new AdminError(1, this.getClass());
    }

    public long compare(ValueComponent obj1, ValueComponent obj2) {
        if (!(obj1 instanceof StreamValue)) {
            throw new AdminError(2, this.getClass());
        }
        if (obj1.getSyntax() == obj2.getSyntax()) {
            return 0L;
        }
        return obj1.getSyntax().getId() - obj2.getSyntax().getId();
    }

    public String toString(ValueComponent obj) {
        if (!(obj instanceof StreamValue)) {
            return obj.toString();
        }
        StringBuffer strBuf = new StringBuffer();
        byte[] shortStreamString = new byte[256];
        try {
            InputStream inputStream = ((StreamValue)obj).getValue();
            inputStream.read(shortStreamString);
            if (this.isDataASCII(shortStreamString)) {
                for (int i = 0; i < shortStreamString.length; ++i) {
                    strBuf.append((char)shortStreamString[i]);
                }
            } else {
                for (int i = 0; i < shortStreamString.length; ++i) {
                    strBuf.append(new Byte(shortStreamString[i]).toString());
                }
            }
            inputStream.close();
        }
        catch (IOException iOException) {
        }
        catch (SPIException sPIException) {
            // empty catch block
        }
        return strBuf.toString();
    }

    public abstract Syntax getSyntax();

    public boolean isWithinBounds(ValueComponent comp, long lowerBound, long upperBound) {
        if (comp instanceof StreamValue) {
            return false;
        }
        throw new AdminError(3, this.getClass());
    }

    private boolean isDataASCII(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (data[i] > 31 && data[i] < 127 || data[i] == 10 || data[i] == 13) continue;
            return false;
        }
        return true;
    }

    private class EmptyStreamFactory
    implements InputStreamFactory {
        private EmptyStreamFactory() {
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(new byte[0]);
        }
    }
}

