/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueListPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

public final class ValueList
extends ValueComponent
implements PropertyChangeListener,
Cloneable,
Serializable {
    private Vector values = new Vector(5);
    private ValueList rootValueListClone = null;
    private ArrayList propertyListeners = new ArrayList(5);
    private static final int BAD_CLONE_IMPL = 1;
    private static final int BAD_FACADE = 2;

    public ValueList(Syntax syn) {
        super(syn);
    }

    public void initList(ValueComponent comp) {
        this.values.addElement(comp);
        if (comp instanceof ValueList) {
            ((ValueList)comp).addPropertyChangeListener(this);
        }
    }

    public ValueComponent getElementAt(int index) throws ArrayIndexOutOfBoundsException {
        return (ValueComponent)this.values.elementAt(index);
    }

    public boolean canInsertComponent(ValueComponent comp) {
        return this.getListStrategy().canInsertComponent(this, comp);
    }

    public boolean canRemoveComponent(ValueComponent comp) {
        return this.getListStrategy().canRemoveComponent(this, comp);
    }

    public synchronized boolean insertComponent(ValueComponent comp) {
        if (this.canInsertComponent(comp)) {
            this.values.addElement(comp);
            ValueListPropertyChangeEvent event = new ValueListPropertyChangeEvent(this, this, null, null, comp);
            this.notifyPropertyChangeListeners(event);
            if (comp instanceof ValueList) {
                ((ValueList)comp).addPropertyChangeListener(this);
            }
            return true;
        }
        return false;
    }

    public synchronized boolean insertComponentAt(ValueComponent comp, int index) throws ArrayIndexOutOfBoundsException {
        if (this.getListStrategy().canInsertComponent(this, comp)) {
            this.values.insertElementAt(comp, index);
            ValueListPropertyChangeEvent event = new ValueListPropertyChangeEvent(this, this, null, null, comp);
            this.notifyPropertyChangeListeners(event);
            if (comp instanceof ValueList) {
                ((ValueList)comp).addPropertyChangeListener(this);
            }
            return true;
        }
        return false;
    }

    public synchronized boolean removeComponent(ValueComponent comp) {
        if (this.canRemoveComponent(comp)) {
            int index = this.indexOf(comp);
            if (index == -1) {
                return false;
            }
            this.values.removeElementAt(index);
            ValueListPropertyChangeEvent event = new ValueListPropertyChangeEvent(this, this, null, comp, null);
            if (comp instanceof ValueList) {
                ((ValueList)comp).removePropertyChangeListener(this);
            }
            this.notifyPropertyChangeListeners(event);
            return true;
        }
        return false;
    }

    public synchronized boolean removeComponentAt(int index) {
        if (index < 0 || index >= this.getComponentCount()) {
            return false;
        }
        ValueComponent comp = this.getElementAt(index);
        this.values.removeElementAt(index);
        ValueListPropertyChangeEvent event = new ValueListPropertyChangeEvent(this, this, null, comp, null);
        if (comp instanceof ValueList) {
            ((ValueList)comp).removePropertyChangeListener(this);
        }
        this.notifyPropertyChangeListeners(event);
        return true;
    }

    public synchronized boolean replaceComponent(ValueComponent oldComp, ValueComponent newComp) {
        int index = this.indexOf(oldComp);
        if (index == -1) {
            return false;
        }
        return this.replaceComponentAt(newComp, index);
    }

    public synchronized boolean replaceComponentAt(ValueComponent newComp, int index) throws ArrayIndexOutOfBoundsException {
        ValueComponent oldComp = this.getElementAt(index);
        if (oldComp.getSyntax() != newComp.getSyntax()) {
            return false;
        }
        this.values.setElementAt(newComp, index);
        ValueListPropertyChangeEvent event = new ValueListPropertyChangeEvent(this, this, null, oldComp, newComp);
        if (oldComp instanceof ValueList) {
            ((ValueList)oldComp).removePropertyChangeListener(this);
            ((ValueList)newComp).addPropertyChangeListener(this);
        }
        this.notifyPropertyChangeListeners(event);
        return true;
    }

    public ValueList getRootListClone() {
        return this.rootValueListClone;
    }

    public void setListAsRoot() {
        this.rootValueListClone = (ValueList)this.clone();
    }

    public boolean contains(ValueComponent comp) {
        return this.values.contains(comp);
    }

    public synchronized int indexOf(ValueComponent comp) {
        return this.values.indexOf(comp);
    }

    public int getComponentCount() {
        return this.values.size();
    }

    public Enumeration getComponents() {
        return this.values.elements();
    }

    public synchronized Object clone() {
        try {
            ValueList list = (ValueList)super.clone();
            list.values = (Vector)this.values.clone();
            for (int i = 0; i < list.values.size(); ++i) {
                Object vc = list.values.elementAt(i);
                if (!(vc instanceof ValueList)) continue;
                list.values.setElementAt(((ValueList)vc).clone(), i);
            }
            list.propertyListeners = new ArrayList();
            return list;
        }
        catch (CloneNotSupportedException e) {
            throw new AdminError(1, this.getClass());
        }
    }

    public Object createFacade() {
        try {
            return this.getListStrategy().createFacade(this);
        }
        catch (IncompatibleComponentException e) {
            throw new AdminError(2, this.getClass());
        }
    }

    public Vector getAddableSyntaxes() {
        return this.getListStrategy().getAddableSyntaxes(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        ValueListPropertyChangeEvent valueListEvent = (ValueListPropertyChangeEvent)event;
        valueListEvent.setRootValueList(this);
        this.notifyPropertyChangeListeners(event);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.propertyListeners.contains(listener)) {
            this.propertyListeners.add(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.remove(listener);
    }

    private void notifyPropertyChangeListeners(PropertyChangeEvent event) {
        ArrayList listener = (ArrayList)this.propertyListeners.clone();
        for (PropertyChangeListener pl : listener) {
            pl.propertyChange(event);
        }
    }

    private ListStrategy getListStrategy() {
        return (ListStrategy)this.getSyntax().getStrategy();
    }
}

