/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;

public abstract class ValueListFacade {
    protected ValueList valueList;
    private static int REPLACE_COMPONENT = 1;
    private static int CREATE_COMPONENT = 2;

    public ValueListFacade(ValueList valueList) {
        this.valueList = valueList;
    }

    public final ValueList getValueList() {
        return this.valueList;
    }

    protected final void replaceStringValue(String str, int index) throws ArrayIndexOutOfBoundsException {
        try {
            ValueComponent oldValue = this.valueList.getElementAt(index);
            ValueComponent newValue = oldValue.getSyntax().createValueComponent(str);
            this.replaceComp(newValue, index);
        }
        catch (ComponentCreationException e) {
            throw new AdminError(CREATE_COMPONENT, this.getClass());
        }
    }

    protected final void replaceLongValue(long value, int index) throws ArrayIndexOutOfBoundsException {
        try {
            ValueComponent oldValue = this.valueList.getElementAt(index);
            ValueComponent newValue = oldValue.getSyntax().createValueComponent(new Long(value));
            this.replaceComp(newValue, index);
        }
        catch (ComponentCreationException e) {
            throw new AdminError(CREATE_COMPONENT, this.getClass());
        }
    }

    protected final void replaceHexValue(byte[] value, int index) throws ArrayIndexOutOfBoundsException {
        try {
            ValueComponent oldValue = this.valueList.getElementAt(index);
            ValueComponent newValue = oldValue.getSyntax().createValueComponent(value);
            this.replaceComp(newValue, index);
        }
        catch (ComponentCreationException e) {
            throw new AdminError(CREATE_COMPONENT, this.getClass());
        }
    }

    protected final void replaceBooleanValue(boolean value, int index) throws ArrayIndexOutOfBoundsException {
        try {
            ValueComponent oldValue = this.valueList.getElementAt(index);
            ValueComponent newValue = oldValue.getSyntax().createValueComponent(new Boolean(value));
            this.replaceComp(newValue, index);
        }
        catch (ComponentCreationException e) {
            throw new AdminError(CREATE_COMPONENT, this.getClass());
        }
    }

    protected final void replaceValueList(ValueList newValue, int index) throws ArrayIndexOutOfBoundsException {
        this.replaceComp(newValue, index);
    }

    private final void replaceComp(ValueComponent newVal, int index) {
        if (!this.valueList.replaceComponentAt(newVal, index)) {
            throw new AdminError(REPLACE_COMPONENT, this.getClass());
        }
    }
}

