/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ldap.LDAPAttributeFlags;

public final class LDAPAttributeDefinition
extends AttributeDefinition {
    private String oid;
    private LDAPAttributeFlags attrFlags;
    private String NDAPName;
    String supOID;
    String equalityOID;
    String orderingOID;
    String substrOID;

    public LDAPAttributeDefinition(String attrName, Syntax syntax, LDAPAttributeFlags flags, String oid) throws NamespaceException {
        super(attrName, syntax);
        this.oid = oid;
        this.attrFlags = (LDAPAttributeFlags)flags.clone();
    }

    public LDAPAttributeDefinition(String attrName, Syntax syntax, long lowerBound, long upperBound, String[] aliasNames, LDAPAttributeFlags flags, String oid, String NDAPName) throws NamespaceException {
        this(attrName, syntax, lowerBound, upperBound, aliasNames, flags, oid, NDAPName, null, null, null, null);
    }

    public LDAPAttributeDefinition(String attrName, Syntax syntax, long lowerBound, long upperBound, String[] aliasNames, LDAPAttributeFlags flags, String oid, String NDAPName, String supOID, String equalityOID, String orderingOID, String substrOID) throws NamespaceException {
        super(attrName, syntax, flags.isFlagSet(2), lowerBound, upperBound, aliasNames);
        this.attrFlags = (LDAPAttributeFlags)flags.clone();
        this.oid = oid;
        this.NDAPName = NDAPName;
        this.supOID = supOID;
        this.equalityOID = equalityOID;
        this.orderingOID = orderingOID;
        this.substrOID = substrOID;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LDAPAttributeDefinition) {
            LDAPAttributeDefinition other = (LDAPAttributeDefinition)obj;
            if (!this.oid.equals(other.oid)) {
                return false;
            }
            if (super.equals(obj) && this.attrFlags.equals(other.attrFlags)) {
                return true;
            }
        }
        return false;
    }

    public boolean isSingleValued() {
        return this.attrFlags.isFlagSet(1);
    }

    public boolean isHidden() {
        return this.attrFlags.isFlagSet(16);
    }

    public boolean isReadOnly() {
        return this.attrFlags.isFlagSet(8);
    }

    public LDAPAttributeFlags getAttributeFlag() {
        return (LDAPAttributeFlags)this.attrFlags.clone();
    }

    public String getOID() {
        return this.oid;
    }

    public void setOID(String modifiedOID) {
        this.oid = modifiedOID;
    }

    public String getNDAPName() {
        return this.NDAPName;
    }

    public String getSupOID() {
        return this.supOID;
    }

    public String getEqualityOID() {
        return this.equalityOID;
    }

    public String getOrderingOID() {
        return this.orderingOID;
    }

    public String getSubstringOID() {
        return this.substrOID;
    }

    public ObjectAttribute createAttribute() {
        ObjectAttribute attr = new ObjectAttribute(this);
        try {
            attr.addComponent(this.getSyntax().createValueComponent());
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        return attr;
    }

    public void setSyntax(Syntax syntax) {
        this.syntax = syntax;
    }

    public boolean isAberrant() {
        return this.name.equals("objectClass");
    }

    public boolean isOperational() {
        return (this.attrFlags.getFlags() & 0x1000) != 0;
    }
}

