/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ldap.AttrFlag;

public final class LDAPAttributeFlags
implements Cloneable {
    public static final int SINGLE_VALUED = 1;
    public static final int SIZED = 2;
    public static final int NONREMOVABLE = 4;
    public static final int READ_ONLY = 8;
    public static final int HIDDEN = 16;
    public static final int NO_SYNC_IMMEDIATE = 64;
    public static final int PUBLIC_READ = 128;
    public static final int SERVER_READ = 256;
    public static final int WRITE_MANAGED = 512;
    public static final int PER_REPLICA = 1024;
    public static final int SCHEDULE_SYNC_NEVER = 2048;
    public static final int OPERATIONAL = 4096;
    public static final int SPARSE_REQUIRED = 8192;
    public static final int SPARSE_OPERATIONAL = 16384;
    public static final int BOTH_MANAGED = 32768;
    public static final int ENCRYPTED_SYNC = 65536;
    private static final int CLONE_NOT_SUPPORTED = 1;
    private int flags;
    private static final AttrFlag[] attrFlagTable = new AttrFlag[]{new AttrFlag(1, "Single valued"), new AttrFlag(2, "Sized"), new AttrFlag(4, "Non-removable"), new AttrFlag(8, "Read-only"), new AttrFlag(16, "Hidden"), new AttrFlag(64, "Delayed Synchronize"), new AttrFlag(128, "Public Read"), new AttrFlag(256, "Server Read"), new AttrFlag(512, "Write managed"), new AttrFlag(1024, "Per replica"), new AttrFlag(2048, "Never schedule synch"), new AttrFlag(4096, "Operational"), new AttrFlag(8192, "Sparse Required"), new AttrFlag(16384, "Sparse Operational"), new AttrFlag(32768, "Both Managed"), new AttrFlag(65536, "Encrypted synch")};

    public LDAPAttributeFlags(int flags) {
        this.flags = flags;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LDAPAttributeFlags) {
            LDAPAttributeFlags attrFlags = (LDAPAttributeFlags)obj;
            return attrFlags.flags == this.flags;
        }
        return false;
    }

    public boolean isFlagSet(int flagId) {
        return 0 != (this.flags & flagId);
    }

    public void setFlag(int flagId) {
        this.flags |= flagId;
    }

    public void clearFlag(int flagId) {
        this.flags &= ~flagId;
    }

    public Object clone() {
        try {
            return (LDAPAttributeFlags)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AdminError(1, this.getClass());
        }
    }

    public String[] getStrings(long upper, long lower) {
        int indx;
        int count = 0;
        for (indx = 0; indx < attrFlagTable.length; ++indx) {
            if (0 == (this.flags & LDAPAttributeFlags.attrFlagTable[indx].flag)) continue;
            ++count;
        }
        String[] flagStrings = new String[count];
        count = 0;
        for (indx = 0; indx < attrFlagTable.length; ++indx) {
            if (0 == (this.flags & LDAPAttributeFlags.attrFlagTable[indx].flag)) continue;
            if (2 == LDAPAttributeFlags.attrFlagTable[indx].flag) {
                String lowerStr = "";
                if (lower != Integer.MIN_VALUE) {
                    lowerStr = Long.toString(lower);
                }
                String upperStr = "";
                if (upper != Integer.MAX_VALUE) {
                    upperStr = Long.toString(upper);
                }
                flagStrings[count++] = new String(LDAPAttributeFlags.attrFlagTable[indx].string + " (" + lowerStr + ".." + upperStr + ")");
                continue;
            }
            flagStrings[count++] = LDAPAttributeFlags.attrFlagTable[indx].string;
        }
        return flagStrings;
    }
}

