/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.DateValue;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.GSERValue;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.nds.TimeStampFacade;
import java.util.StringTokenizer;
import java.util.Vector;

final class NVDSTimeStampStrategy
extends ListStrategy {
    NVDSTimeStampStrategy() {
    }

    public ValueComponent createValueComponent() {
        ValueList list = new ValueList(LDAPSyntax.SYN_NVDS_TIMESTAMP);
        list.initList(LDAPSyntax.SYN_GENERALIZEDTIME.createValueComponent());
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent());
        list.initList(LDAPSyntax.SYN_DIRECTORY_STRING.createValueComponent());
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent());
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ValueComponent createValueComponent(Object paramObj) throws ComponentCreationException {
        String genTime = null;
        Number timeCount = null;
        String replicaName = null;
        Number changeCount = null;
        ValueList list = new ValueList(LDAPSyntax.SYN_NVDS_TIMESTAMP);
        if (paramObj instanceof Vector) {
            Vector compList = (Vector)paramObj;
            if (compList.size() == 4) {
                genTime = (String)compList.get(0);
                timeCount = (Number)compList.get(1);
                replicaName = (String)compList.get(2);
                changeCount = (Number)compList.get(3);
            } else {
                if (compList.size() != 3) throw new ComponentCreationException();
                long seconds = ((Number)compList.get(0)).longValue();
                genTime = DateValue.msToGeneralizedTime(seconds * 1000L);
                timeCount = new Integer(0);
                replicaName = compList.get(1).toString();
                changeCount = (Number)compList.get(2);
            }
        } else {
            if (!(paramObj instanceof String)) throw new ComponentCreationException();
            String str = ((String)paramObj).trim();
            if (str.charAt(0) == '{') {
                GSERValue gval = new GSERValue(str);
                genTime = (String)gval.get("time");
                try {
                    timeCount = new Integer((String)gval.get("timeCount"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    replicaName = (String)gval.get("replicaName");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    changeCount = new Integer((String)gval.get("changeCount"));
                }
                catch (Exception exception) {}
            } else {
                StringTokenizer st = new StringTokenizer((String)paramObj, "#");
                if (st.countTokens() != 3) {
                    throw new ComponentCreationException();
                }
                long seconds = new Long(st.nextToken());
                genTime = DateValue.msToGeneralizedTime(seconds * 1000L);
                timeCount = new Integer(0);
                replicaName = st.nextToken();
                changeCount = new Integer(st.nextToken());
            }
        }
        if (timeCount == null) {
            timeCount = new Integer(0);
        }
        if (replicaName == null) {
            replicaName = "";
        }
        if (changeCount == null) {
            changeCount = new Integer(0);
        }
        list.initList(LDAPSyntax.SYN_GENERALIZEDTIME.createValueComponent(genTime));
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent(timeCount));
        list.initList(LDAPSyntax.SYN_DIRECTORY_STRING.createValueComponent(replicaName));
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent(changeCount));
        return list;
    }

    public Object createFacade(ValueComponent comp) throws IncompatibleComponentException {
        return new TimeStampFacade((ValueList)comp);
    }

    public String toString(ValueComponent vc) {
        if (vc instanceof ValueList) {
            ValueList list = (ValueList)vc;
            return "{ time \"" + ((DateValue)list.getElementAt(0)).getGeneralizedTime() + "\", timeCount " + list.getElementAt(1).toString() + ", replicaName \"" + list.getElementAt(2).toString() + "\", changeCount " + list.getElementAt(3).toString() + " }";
        }
        return vc.toString();
    }
}

