/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.common.exceptions.FacadeParameterException;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.ValueStrategy;
import com.novell.admin.ns.ldap.LDAPSyntax;

public final class NameAndUIDFacade
extends ValueListFacade {
    private static final int COMP_CREATE = 1;

    public NameAndUIDFacade(ValueList comp) throws IncompatibleComponentException {
        super(comp);
        String name = comp.getSyntax().getName();
        if (!name.equals("Name And Optional UID")) {
            throw new IncompatibleComponentException();
        }
    }

    public static ValueList createValueList(String dn, String bitString) {
        try {
            if (bitString != null && bitString.length() > 0) {
                dn = dn + "#" + bitString;
            }
            ValueComponent vc = LDAPSyntax.SYN_NAME_UID.createValueComponent(dn);
            return (ValueList)vc;
        }
        catch (ComponentCreationException e) {
            throw new AdminError(1, "com.novell.admin.ns.ldap.NameAndUIDFacade");
        }
    }

    public String getDN() {
        StringValue v = (StringValue)this.valueList.getElementAt(0);
        return v.getValue();
    }

    public void setDN(String dn) {
        ValueStrategy svs = (ValueStrategy)LDAPSyntax.SYN_DN.getStrategy();
        if (!svs.canCreateValue(dn)) {
            throw new FacadeParameterException();
        }
        this.replaceStringValue(dn, 0);
    }

    public String getBitString() {
        if (this.valueList.getComponentCount() < 2) {
            return "";
        }
        StringValue v = (StringValue)this.valueList.getElementAt(1);
        return v.getValue();
    }

    public void setBitString(String bitString) {
        try {
            if (this.valueList.getComponentCount() == 2) {
                if (bitString == null || bitString.length() == 0) {
                    this.valueList.removeComponentAt(1);
                } else {
                    this.replaceStringValue(bitString, 1);
                }
            } else {
                ValueComponent vc = LDAPSyntax.SYN_BIT_STRING.getStrategy().createValueComponent(bitString);
                this.valueList.insertComponent(vc);
            }
        }
        catch (ComponentCreationException err) {
            throw new AdminError(1, "com.novell.admin.ns.ldap.FaxTelephoneNumberFacade");
        }
    }
}

