/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import java.util.Vector;

public class PString {
    private String s;
    private int ptr;
    private int len;

    PString(String str) {
        this.s = str;
        this.ptr = 0;
        this.len = this.s.length();
    }

    public boolean atEnd() {
        return this.ptr == this.len;
    }

    public void skipWS() {
        while (!(this.atEnd() || this.s.charAt(this.ptr) != ' ' && this.s.charAt(this.ptr) != '\t' && this.s.charAt(this.ptr) != '$')) {
            ++this.ptr;
        }
    }

    public String getToken() {
        boolean quoted = false;
        if (this.atEnd()) {
            return null;
        }
        this.skipWS();
        char c = this.s.charAt(this.ptr);
        if (c == '\'') {
            quoted = true;
            ++this.ptr;
            if (this.atEnd()) {
                return null;
            }
        }
        int start = this.ptr;
        while (!this.atEnd()) {
            c = this.s.charAt(this.ptr);
            if (quoted) {
                if (c == '\'') {
                    String tok = this.s.substring(start, this.ptr);
                    ++this.ptr;
                    this.skipWS();
                    return tok;
                }
                ++this.ptr;
                continue;
            }
            if (c == '(') {
                ++this.ptr;
                this.skipWS();
                return "(";
            }
            if (c == ')') {
                if (start == this.ptr) {
                    ++this.ptr;
                    this.skipWS();
                    return ")";
                }
                return this.s.substring(start, this.ptr);
            }
            if (c == ' ' || c == '\t') {
                String tok = this.s.substring(start, this.ptr);
                ++this.ptr;
                this.skipWS();
                return tok;
            }
            ++this.ptr;
        }
        return this.s.substring(start, this.ptr);
    }

    public String[] getTokens() {
        String t = this.getToken();
        if (t == null) {
            return null;
        }
        if (!t.equals("(")) {
            return new String[]{t};
        }
        Vector<String> vec = new Vector<String>();
        while ((t = this.getToken()) != null && !t.equals(")")) {
            vec.add(t);
        }
        return vec.toArray(new String[0]);
    }
}

